/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collectd.wmi.WmiAgentState;
import org.opennms.netmgt.collectd.wmi.WmiCollectionAttributeType;
import org.opennms.netmgt.collectd.wmi.WmiCollectionResource;
import org.opennms.netmgt.collectd.wmi.WmiCollectionSet;
import org.opennms.netmgt.collectd.wmi.WmiMultiInstanceCollectionResource;
import org.opennms.netmgt.collectd.wmi.WmiResourceType;
import org.opennms.netmgt.collectd.wmi.WmiSingleInstanceCollectionResource;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.support.IndexStorageStrategy;
import org.opennms.netmgt.collection.support.PersistAllSelectorStrategy;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.WmiDataCollectionConfigFactory;
import org.opennms.netmgt.config.WmiPeerFactory;
import org.opennms.netmgt.config.datacollection.PersistenceSelectorStrategy;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.datacollection.StorageStrategy;
import org.opennms.netmgt.config.wmi.Attrib;
import org.opennms.netmgt.config.wmi.WmiCollection;
import org.opennms.netmgt.config.wmi.Wpm;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.protocols.wmi.WmiClient;
import org.opennms.protocols.wmi.WmiException;
import org.opennms.protocols.wmi.WmiManager;
import org.opennms.protocols.wmi.WmiParams;
import org.opennms.protocols.wmi.WmiResult;
import org.opennms.protocols.wmi.wbem.OnmsWbemObject;
import org.opennms.protocols.wmi.wbem.OnmsWbemObjectSet;
import org.opennms.protocols.wmi.wbem.OnmsWbemProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WmiCollector
implements ServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(WmiCollector.class);
    private final Map<Integer, WmiAgentState> m_scheduledNodes = new HashMap<Integer, WmiAgentState>();
    private Map<String, AttributeGroupType> m_groupTypeList = new HashMap<String, AttributeGroupType>();
    private Map<String, WmiCollectionAttributeType> m_attribTypeList = new HashMap<String, WmiCollectionAttributeType>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, Object> parameters) {
        String collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", (String)ParameterMap.getKeyedString(parameters, (String)"wmi-collection", null));
        WmiCollection collection = WmiDataCollectionConfigFactory.getInstance().getWmiCollection(collectionName);
        WmiAgentState agentState = this.m_scheduledNodes.get(agent.getNodeId());
        this.loadAttributeGroupList(collection);
        this.loadAttributeTypeList(collection);
        WmiCollectionSet collectionSet = new WmiCollectionSet();
        collectionSet.setCollectionTimestamp(new Date());
        WmiSingleInstanceCollectionResource nodeResource = new WmiSingleInstanceCollectionResource(agent);
        for (Wpm wpm : collection.getWpms().getWpm()) {
            if (agentState.shouldCheckAvailability(wpm.getName(), wpm.getRecheckInterval()) && !this.isGroupAvailable(agentState, wpm) || !agentState.groupIsAvailable(wpm.getName())) continue;
            WmiClient client = null;
            try {
                agentState.connect(wpm.getWmiNamespace());
                client = (WmiClient)agentState.getWmiClient();
                OnmsWbemObjectSet wOS = client.performInstanceOf(wpm.getWmiClass());
                if (wOS == null) continue;
                for (int i = 0; i < wOS.count(); ++i) {
                    WmiCollectionResource resource = null;
                    OnmsWbemObject obj = wOS.get(i);
                    if (wOS.count() > 1) {
                        OnmsWbemProperty prop = obj.getWmiProperties().getByName(wpm.getKeyvalue());
                        Object propVal = prop.getWmiValue();
                        String instance = null;
                        instance = propVal instanceof String ? (String)propVal : propVal.toString();
                        resource = new WmiMultiInstanceCollectionResource(agent, instance, this.getWmiResourceType(agent, wpm.getResourceType()));
                    } else {
                        resource = nodeResource;
                    }
                    for (Attrib attrib : wpm.getAttrib()) {
                        OnmsWbemProperty prop = obj.getWmiProperties().getByName(attrib.getWmiObject());
                        WmiCollectionAttributeType attribType = this.m_attribTypeList.get(attrib.getName());
                        resource.setAttributeValue((CollectionAttributeType)attribType, prop.getWmiValue());
                    }
                    collectionSet.getCollectionResources().add(resource);
                }
            }
            catch (WmiException e) {
                LOG.info("unable to collect params for wpm '{}'", (Object)wpm.getName(), (Object)e);
            }
            finally {
                if (client == null) continue;
                try {
                    client.disconnect();
                }
                catch (WmiException e) {
                    LOG.warn("An error occurred disconnecting while collecting from WMI.", (Throwable)e);
                }
            }
        }
        collectionSet.setStatus(1);
        return collectionSet;
    }

    private void loadAttributeGroupList(WmiCollection collection) {
        for (Wpm wpm : collection.getWpms().getWpm()) {
            AttributeGroupType attribGroupType1 = new AttributeGroupType(wpm.getName(), wpm.getIfType());
            this.m_groupTypeList.put(wpm.getName(), attribGroupType1);
        }
    }

    private void loadAttributeTypeList(WmiCollection collection) {
        for (Wpm wpm : collection.getWpms().getWpm()) {
            for (Attrib attrib : wpm.getAttrib()) {
                AttributeGroupType attribGroupType = this.m_groupTypeList.get(wpm.getName());
                WmiCollectionAttributeType attribType = new WmiCollectionAttributeType(attrib, attribGroupType);
                this.m_attribTypeList.put(attrib.getName(), attribType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGroupAvailable(WmiAgentState agentState, Wpm wpm) {
        LOG.debug("Checking availability of group {} via object {} of class {} in namespace {}", new Object[]{wpm.getName(), wpm.getKeyvalue(), wpm.getWmiClass(), wpm.getWmiNamespace()});
        WmiManager manager = null;
        try {
            manager = agentState.getManager();
            manager.setNamespace(wpm.getWmiNamespace());
            manager.init();
            WmiParams params = new WmiParams("InstanceOf", "not-applicable", "NOOP", wpm.getWmiClass(), wpm.getKeyvalue());
            WmiResult result = manager.performOp(params);
            boolean isAvailable = result.getResultCode() == 0;
            agentState.setGroupIsAvailable(wpm.getName(), isAvailable);
            LOG.debug("Group {} is {}{}.", new Object[]{wpm.getName(), isAvailable ? "" : "not ", "available"});
        }
        catch (WmiException e) {
            LOG.warn("Error checking group ({}) availability.", (Object)wpm.getName(), (Object)e);
            agentState.setGroupIsAvailable(wpm.getName(), false);
            boolean bl = false;
            return bl;
        }
        finally {
            if (manager != null) {
                try {
                    manager.close();
                }
                catch (WmiException e) {
                    LOG.warn("An error occurred closing the WMI Manager", (Throwable)e);
                }
            }
        }
        return true;
    }

    private WmiResourceType getWmiResourceType(CollectionAgent agent, String resourceType) {
        ResourceType rt = (ResourceType)DataCollectionConfigFactory.getInstance().getConfiguredResourceTypes().get(resourceType);
        if (rt == null) {
            LOG.debug("getWmiResourceType: using default WMI resource type strategy - index / all");
            rt = new ResourceType();
            rt.setName(resourceType);
            rt.setStorageStrategy(new StorageStrategy());
            rt.getStorageStrategy().setClazz(IndexStorageStrategy.class.getName());
            rt.setPersistenceSelectorStrategy(new PersistenceSelectorStrategy());
            rt.getPersistenceSelectorStrategy().setClazz(PersistAllSelectorStrategy.class.getName());
        }
        WmiResourceType type = new WmiResourceType(agent, rt);
        return type;
    }

    public void initialize(Map<String, String> parameters) {
        LOG.debug("initialize: Initializing WmiCollector.");
        this.m_scheduledNodes.clear();
        this.initWMIPeerFactory();
        this.initWMICollectionConfig();
        this.initializeRrdRepository();
    }

    private void initWMIPeerFactory() {
        LOG.debug("initialize: Initializing WmiPeerFactory");
        try {
            WmiPeerFactory.init();
        }
        catch (MarshalException e) {
            LOG.error("initialize: Error marshalling configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            LOG.error("initialize: Error validating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            LOG.error("initialize: Error reading configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private void initWMICollectionConfig() {
        LOG.debug("initialize: Initializing collector: {}", this.getClass());
        try {
            WmiDataCollectionConfigFactory.init();
        }
        catch (FileNotFoundException e) {
            LOG.error("initialize: Error locating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            LOG.error("initialize: Error reading configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private void initializeRrdRepository() {
        LOG.debug("initializeRrdRepository: Initializing RRD repo from WmiCollector...");
        this.initializeRrdDirs();
    }

    private void initializeRrdDirs() {
        File f = new File(WmiDataCollectionConfigFactory.getInstance().getRrdPath());
        if (!f.isDirectory() && !f.mkdirs()) {
            throw new RuntimeException("Unable to create RRD file repository.  Path doesn't already exist and could not make directory: " + WmiDataCollectionConfigFactory.getInstance().getRrdPath());
        }
    }

    public void initialize(CollectionAgent agent, Map<String, Object> parameters) {
        LOG.debug("initialize: Initializing WMI collection for agent: {}", (Object)agent);
        Integer scheduledNodeKey = agent.getNodeId();
        WmiAgentState nodeState = this.m_scheduledNodes.get(scheduledNodeKey);
        if (nodeState != null) {
            LOG.info("initialize: Not scheduling interface for WMI collection: {}", (Object)nodeState.getAddress());
            StringBuffer sb = new StringBuffer();
            sb.append("initialize service: ");
            sb.append(" for address: ");
            sb.append(nodeState.getAddress());
            sb.append(" already scheduled for collection on node: ");
            sb.append(agent);
            LOG.debug(sb.toString());
            throw new IllegalStateException(sb.toString());
        }
        nodeState = new WmiAgentState((InetAddress)agent.getAddress(), parameters);
        LOG.info("initialize: Scheduling interface for collection: {}", (Object)nodeState.getAddress());
        this.m_scheduledNodes.put(scheduledNodeKey, nodeState);
    }

    public void release() {
        this.m_scheduledNodes.clear();
    }

    public void release(CollectionAgent agent) {
        WmiAgentState nodeState = this.m_scheduledNodes.get(agent.getNodeId());
        if (nodeState != null) {
            this.m_scheduledNodes.remove(agent.getNodeId());
        }
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return WmiDataCollectionConfigFactory.getInstance().getRrdRepository(collectionName);
    }
}

