/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.support.builder;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.support.AbstractCollectionAttribute;
import org.opennms.netmgt.collection.support.AbstractCollectionAttributeType;
import org.opennms.netmgt.collection.support.AbstractCollectionResource;
import org.opennms.netmgt.collection.support.MultiResourceCollectionSet;
import org.opennms.netmgt.collection.support.builder.Attribute;
import org.opennms.netmgt.collection.support.builder.AttributeType;
import org.opennms.netmgt.collection.support.builder.CollectionStatus;
import org.opennms.netmgt.collection.support.builder.NumericAttribute;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.collection.support.builder.StringAttribute;

public class CollectionSetBuilder {
    private final CollectionAgent m_agent;
    private CollectionStatus m_status = CollectionStatus.SUCCEEDED;
    private Date m_timestamp = new Date();
    private Map<Resource, List<Attribute<?>>> m_attributesByResource = new LinkedHashMap();

    public CollectionSetBuilder(CollectionAgent agent) {
        this.m_agent = Objects.requireNonNull(agent, "agent cannot be null");
    }

    public CollectionSetBuilder withStatus(CollectionStatus status) {
        this.m_status = Objects.requireNonNull(status, "status cannot be null");
        return this;
    }

    public CollectionSetBuilder withTimestamp(Date timestamp) {
        this.m_timestamp = Objects.requireNonNull(timestamp, "timestamp cannot be null");
        return this;
    }

    public CollectionSetBuilder withNumericAttribute(Resource resource, String group, String name, Number value, AttributeType type) {
        return this.withAttribute(new NumericAttribute(resource, group, name, value, type));
    }

    public CollectionSetBuilder withStringAttribute(Resource resource, String group, String name, String value) {
        return this.withAttribute(new StringAttribute(resource, group, name, value));
    }

    private CollectionSetBuilder withAttribute(Attribute<?> attribute) {
        if (this.m_attributesByResource.containsKey(attribute.getResource())) {
            this.m_attributesByResource.get(attribute.getResource()).add(attribute);
        } else {
            ArrayList attributes = new ArrayList();
            attributes.add(attribute);
            this.m_attributesByResource.put(attribute.getResource(), attributes);
        }
        return this;
    }

    public CollectionSet build() {
        MultiResourceCollectionSet<CollectionResource> collectionSet = new MultiResourceCollectionSet<CollectionResource>(){};
        collectionSet.setCollectionTimestamp(this.m_timestamp);
        collectionSet.setStatus(this.m_status.getCode());
        for (Map.Entry<Resource, List<Attribute<?>>> entry : this.m_attributesByResource.entrySet()) {
            final Resource resource = entry.getKey();
            AbstractCollectionResource collectionResource = new AbstractCollectionResource(this.m_agent){

                @Override
                public String getResourceTypeName() {
                    return "*";
                }

                @Override
                public String getInstance() {
                    return resource.getInstance();
                }

                @Override
                public Path getPath() {
                    return super.getPath().resolve(resource.getPath(this));
                }

                public String toString() {
                    return String.format("Resource[%s]/Node[%d]", resource, this.m_agent.getNodeId());
                }
            };
            for (final Attribute<?> attribute : entry.getValue()) {
                AttributeGroupType groupType = new AttributeGroupType(attribute.getGroup(), "all");
                AbstractCollectionAttributeType attributeType = new AbstractCollectionAttributeType(groupType){

                    @Override
                    public String getType() {
                        return attribute.getType().getName();
                    }

                    @Override
                    public String getName() {
                        return attribute.getName();
                    }

                    @Override
                    public void storeAttribute(CollectionAttribute collectionAttribute, Persister persister) {
                        if (attribute.getType() == AttributeType.STRING) {
                            persister.persistStringAttribute(collectionAttribute);
                        } else {
                            persister.persistNumericAttribute(collectionAttribute);
                        }
                    }

                    public String toString() {
                        return String.format("AttributeType[%s]/type[%s]", this.getName(), this.getType());
                    }
                };
                collectionResource.addAttribute(new AbstractCollectionAttribute(attributeType, collectionResource){

                    @Override
                    public String getMetricIdentifier() {
                        return attribute.getName();
                    }

                    @Override
                    public Number getNumericValue() {
                        return attribute.getNumericValue();
                    }

                    @Override
                    public String getStringValue() {
                        return attribute.getStringValue();
                    }

                    public String toString() {
                        return String.format("Attribute[%s:%s]", this.getMetricIdentifier(), attribute.getValue());
                    }
                });
            }
            collectionSet.getCollectionResources().add(collectionResource);
        }
        return collectionSet;
    }
}

