/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.proxy.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.opennms.core.rpc.xml.AbstractXmlRpcModule;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.ColumnTracker;
import org.opennms.netmgt.snmp.SingleInstanceTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalkCallback;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.netmgt.snmp.proxy.common.SnmpGetRequestDTO;
import org.opennms.netmgt.snmp.proxy.common.SnmpMultiResponseDTO;
import org.opennms.netmgt.snmp.proxy.common.SnmpRequestDTO;
import org.opennms.netmgt.snmp.proxy.common.SnmpResponseDTO;
import org.opennms.netmgt.snmp.proxy.common.SnmpWalkRequestDTO;

public class SnmpProxyRpcModule
extends AbstractXmlRpcModule<SnmpRequestDTO, SnmpMultiResponseDTO> {
    public static final String RPC_MODULE_ID = "SNMP";
    private final ExecutorService reaperExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "SNMP-Proxy-RPC-Session-Reaper");
        }
    });

    public SnmpProxyRpcModule() {
        super(SnmpRequestDTO.class, SnmpMultiResponseDTO.class);
    }

    public CompletableFuture<SnmpMultiResponseDTO> execute(SnmpRequestDTO request) {
        CompletionStage<SnmpMultiResponseDTO> combinedFuture = CompletableFuture.completedFuture(new SnmpMultiResponseDTO());
        for (SnmpGetRequestDTO getRequest : request.getGetRequests()) {
            CompletableFuture<SnmpResponseDTO> future = this.get(request, getRequest);
            combinedFuture = combinedFuture.thenCombine(future, (m, s) -> {
                m.getResponses().add((SnmpResponseDTO)s);
                return m;
            });
        }
        CompletableFuture<Collection<SnmpResponseDTO>> future = this.walk(request, request.getWalkRequest());
        combinedFuture = combinedFuture.thenCombine(future, (m, s) -> {
            m.getResponses().addAll((Collection<SnmpResponseDTO>)s);
            return m;
        });
        return combinedFuture;
    }

    private CompletableFuture<Collection<SnmpResponseDTO>> walk(SnmpRequestDTO request, List<SnmpWalkRequestDTO> walks) {
        final CompletableFuture<Collection<SnmpResponseDTO>> future = new CompletableFuture<Collection<SnmpResponseDTO>>();
        final LinkedHashMap responsesByCorrelationId = new LinkedHashMap();
        ArrayList<3> trackers = new ArrayList<3>(walks.size());
        for (final SnmpWalkRequestDTO walk : walks) {
            Object tracker;
            if (walk.getInstance() != null) {
                if (walk.getOids().size() != 1) {
                    future.completeExceptionally(new IllegalArgumentException("Single instance requests must have a single OID."));
                    return future;
                }
                SnmpObjId oid2 = walk.getOids().get(0);
                tracker = new SingleInstanceTracker(oid2, new SnmpInstId(walk.getInstance())){

                    protected void storeResult(SnmpResult res) {
                        SnmpProxyRpcModule.addResult(res, walk.getCorrelationId(), responsesByCorrelationId);
                    }
                };
            } else {
                Collection columnTrackers = walk.getOids().stream().map(oid -> SnmpObjId.get((SnmpObjId)oid)).map(objId -> new ColumnTracker(objId)).collect(Collectors.toList());
                tracker = new AggregateTracker(columnTrackers){

                    protected void storeResult(SnmpResult res) {
                        SnmpProxyRpcModule.addResult(res, walk.getCorrelationId(), responsesByCorrelationId);
                    }
                };
            }
            if (walk.getMaxRepetitions() != null) {
                tracker.setMaxRepetitions(walk.getMaxRepetitions().intValue());
            }
            trackers.add((Object)tracker);
        }
        AggregateTracker aggregate = new AggregateTracker(trackers);
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)request.getAgent(), (String)request.getDescription(), (CollectionTracker)aggregate);
        walker.setCallback(new SnmpWalkCallback(){

            public void complete(SnmpWalker tracker, Throwable t) {
                try {
                    if (t != null) {
                        future.completeExceptionally(t);
                    } else {
                        future.complete(responsesByCorrelationId.values());
                    }
                    SnmpProxyRpcModule.this.reaperExecutor.submit(new Runnable(tracker){
                        final /* synthetic */ SnmpWalker val$tracker;
                        {
                            this.val$tracker = snmpWalker;
                        }

                        @Override
                        public void run() {
                            this.val$tracker.close();
                        }
                    });
                }
                catch (Throwable throwable) {
                    SnmpProxyRpcModule.this.reaperExecutor.submit(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
            }
        });
        walker.start();
        return future;
    }

    private static final void addResult(SnmpResult result, String correlationId, Map<String, SnmpResponseDTO> responsesByCorrelationId) {
        SnmpResponseDTO response = responsesByCorrelationId.get(correlationId);
        if (response == null) {
            response = new SnmpResponseDTO();
            response.setCorrelationId(correlationId);
            responsesByCorrelationId.put(correlationId, response);
        }
        response.getResults().add(result);
    }

    private CompletableFuture<SnmpResponseDTO> get(SnmpRequestDTO request, SnmpGetRequestDTO get) {
        SnmpObjId[] oids = get.getOids().toArray(new SnmpObjId[get.getOids().size()]);
        CompletableFuture future = SnmpUtils.getAsync((SnmpAgentConfig)request.getAgent(), (SnmpObjId[])oids);
        return future.thenApply(values -> {
            ArrayList<SnmpResult> results = new ArrayList<SnmpResult>(oids.length);
            for (int i = 0; i < oids.length; ++i) {
                SnmpResult result = new SnmpResult(oids[i], null, values[i]);
                results.add(result);
            }
            SnmpResponseDTO responseDTO = new SnmpResponseDTO();
            responseDTO.setCorrelationId(get.getCorrelationId());
            responseDTO.setResults(results);
            return responseDTO;
        });
    }

    public SnmpMultiResponseDTO createResponseWithException(Throwable ex) {
        return new SnmpMultiResponseDTO(ex);
    }

    public String getId() {
        return RPC_MODULE_ID;
    }
}

