/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.camel;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.opennms.core.camel.JmsQueueNameFactory;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.MessageConsumer;
import org.opennms.core.ipc.sink.api.MessageConsumerManager;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.sink.camel.CamelSinkServerProcessor;
import org.opennms.core.logging.Logging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelMessageConsumerManager
implements MessageConsumerManager {
    private static final Logger LOG = LoggerFactory.getLogger(CamelMessageConsumerManager.class);
    private final CamelContext context;
    private final Multimap<SinkModule<Message>, MessageConsumer<Message>> consumersByModule = LinkedListMultimap.create();
    private final Map<SinkModule<Message>, String> routeIdsByModule = new ConcurrentHashMap<SinkModule<Message>, String>();

    public CamelMessageConsumerManager(CamelContext context) throws Exception {
        this.context = Objects.requireNonNull(context);
        context.start();
    }

    public <T extends Message> void dispatch(SinkModule<T> module, T message) {
        this.consumersByModule.get(module).forEach(c -> c.handleMessage(message));
    }

    public <T extends Message> void registerConsumer(MessageConsumer<T> consumer) throws Exception {
        if (consumer == null) {
            return;
        }
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
            LOG.info("Registering consumer: {}", consumer);
            SinkModule module = consumer.getModule();
            this.consumersByModule.put((Object)module, consumer);
            if (!this.routeIdsByModule.containsKey(module)) {
                LOG.info("Creating route for module: {}", (Object)module);
                DynamicIpcRouteBuilder routeBuilder = new DynamicIpcRouteBuilder(this.context, this, consumer.getModule());
                this.context.addRoutes((RoutesBuilder)routeBuilder);
                this.routeIdsByModule.put((SinkModule<Message>)module, routeBuilder.getRouteId());
            }
        }
    }

    public <T extends Message> void unregisterConsumer(MessageConsumer<T> consumer) throws Exception {
        if (consumer == null) {
            return;
        }
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
            LOG.info("Unregistering consumer: {}", consumer);
            SinkModule module = consumer.getModule();
            this.consumersByModule.remove((Object)module, consumer);
            if (this.consumersByModule.get((Object)module).size() < 1 && this.routeIdsByModule.containsKey(module)) {
                LOG.info("Destroying route for module: {}", (Object)module);
                String routeId = this.routeIdsByModule.get(module);
                this.context.stopRoute(routeId);
                this.context.removeRoute(routeId);
            }
        }
    }

    private static final class DynamicIpcRouteBuilder
    extends RouteBuilder {
        private final CamelMessageConsumerManager consumerManager;
        private final SinkModule<Message> module;

        private DynamicIpcRouteBuilder(CamelContext context, CamelMessageConsumerManager consumerManager, SinkModule<Message> module) {
            super(context);
            this.consumerManager = consumerManager;
            this.module = module;
        }

        public String getRouteId() {
            return "Sink.Server." + this.module.getId();
        }

        public void configure() throws Exception {
            JmsQueueNameFactory queueNameFactory = new JmsQueueNameFactory("Sink", this.module.getId());
            ((RouteDefinition)((RouteDefinition)this.from(String.format("queuingservice:%s", queueNameFactory.getName())).setExchangePattern(ExchangePattern.InOnly)).process((Processor)new CamelSinkServerProcessor(this.consumerManager, this.module))).routeId(this.getRouteId());
        }
    }
}

