/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import org.jline.utils.NonBlockingInputStream;
import org.jline.utils.NonBlockingInputStreamImpl;
import org.jline.utils.NonBlockingPumpInputStream;
import org.jline.utils.NonBlockingPumpReader;
import org.jline.utils.NonBlockingReader;
import org.jline.utils.NonBlockingReaderImpl;

public class NonBlocking {
    public static NonBlockingPumpReader nonBlockingPumpReader() {
        return new NonBlockingPumpReader();
    }

    public static NonBlockingPumpReader nonBlockingPumpReader(int size) {
        return new NonBlockingPumpReader(size);
    }

    public static NonBlockingPumpInputStream nonBlockingPumpInputStream() {
        return new NonBlockingPumpInputStream();
    }

    public static NonBlockingPumpInputStream nonBlockingPumpInputStream(int size) {
        return new NonBlockingPumpInputStream(size);
    }

    public static NonBlockingInputStream nonBlockingStream(NonBlockingReader reader, Charset encoding) {
        return new NonBlockingReaderInputStream(reader, encoding);
    }

    public static NonBlockingInputStream nonBlocking(String name, InputStream inputStream) {
        if (inputStream instanceof NonBlockingInputStream) {
            return (NonBlockingInputStream)inputStream;
        }
        return new NonBlockingInputStreamImpl(name, inputStream);
    }

    public static NonBlockingReader nonBlocking(String name, Reader reader) {
        if (reader instanceof NonBlockingReader) {
            return (NonBlockingReader)reader;
        }
        return new NonBlockingReaderImpl(name, reader);
    }

    public static NonBlockingReader nonBlocking(String name, InputStream inputStream, Charset encoding) {
        return new NonBlockingInputStreamReader(NonBlocking.nonBlocking(name, inputStream), encoding);
    }

    private static class NonBlockingInputStreamReader
    extends NonBlockingReader {
        private final NonBlockingInputStream nbis;
        private final CharsetDecoder decoder;
        private final ByteBuffer bytes;
        private final CharBuffer chars;

        public NonBlockingInputStreamReader(NonBlockingInputStream inputStream, Charset encoding) {
            this(inputStream, (encoding != null ? encoding : Charset.defaultCharset()).newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE), 4);
        }

        public NonBlockingInputStreamReader(NonBlockingInputStream nbis, CharsetDecoder decoder, int bufferSize) {
            this.nbis = nbis;
            this.decoder = decoder;
            this.bytes = ByteBuffer.allocate((int)Math.ceil((float)bufferSize / decoder.maxCharsPerByte()));
            this.chars = CharBuffer.allocate(bufferSize);
            this.bytes.limit(0);
            this.chars.limit(0);
        }

        @Override
        protected int read(long timeout, boolean isPeek) throws IOException {
            boolean isInfinite;
            boolean bl = isInfinite = timeout <= 0L;
            while (!this.chars.hasRemaining() && (isInfinite || timeout > 0L)) {
                int b;
                long start = 0L;
                if (!isInfinite) {
                    start = System.currentTimeMillis();
                }
                if ((b = this.nbis.read(timeout)) == -1) {
                    return -1;
                }
                if (b >= 0) {
                    if (this.bytes.capacity() - this.bytes.limit() < 1) {
                        this.bytes.compact();
                        this.bytes.limit(this.bytes.position());
                        this.bytes.position(0);
                    }
                    if (this.chars.capacity() - this.chars.limit() < 2) {
                        this.chars.compact();
                        this.chars.limit(this.chars.position());
                        this.chars.position(0);
                    }
                    int l = this.bytes.limit();
                    this.bytes.array()[this.bytes.arrayOffset() + l] = (byte)b;
                    this.bytes.limit(l + 1);
                    int p = this.chars.position();
                    l = this.chars.limit();
                    this.chars.position(l);
                    this.chars.limit(this.chars.capacity());
                    this.decoder.decode(this.bytes, this.chars, false);
                    l = this.chars.position();
                    this.chars.position(p);
                    this.chars.limit(l);
                }
                if (isInfinite) continue;
                timeout -= System.currentTimeMillis() - start;
            }
            if (this.chars.hasRemaining()) {
                if (isPeek) {
                    return this.chars.get(this.chars.position());
                }
                return this.chars.get();
            }
            return -2;
        }

        @Override
        public void shutdown() {
            this.nbis.shutdown();
        }

        @Override
        public void close() throws IOException {
            this.nbis.close();
        }
    }

    private static class NonBlockingReaderInputStream
    extends NonBlockingInputStream {
        private final NonBlockingReader reader;
        private final CharsetEncoder encoder;
        private final ByteBuffer bytes;
        private final CharBuffer chars;

        private NonBlockingReaderInputStream(NonBlockingReader reader, Charset charset) {
            this(reader, charset, 4);
        }

        private NonBlockingReaderInputStream(NonBlockingReader reader, Charset charset, int bufferSize) {
            this.reader = reader;
            this.encoder = charset.newEncoder().onUnmappableCharacter(CodingErrorAction.REPLACE).onMalformedInput(CodingErrorAction.REPLACE);
            this.bytes = ByteBuffer.allocate((int)Math.ceil((float)bufferSize * this.encoder.maxBytesPerChar()));
            this.chars = CharBuffer.allocate(bufferSize);
            this.bytes.limit(0);
        }

        @Override
        public int available() throws IOException {
            return (int)((float)this.reader.available() * this.encoder.averageBytesPerChar()) + this.bytes.remaining();
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        public int read(long timeout, boolean isPeek) throws IOException {
            boolean isInfinite;
            boolean bl = isInfinite = timeout <= 0L;
            while (!this.bytes.hasRemaining() && (isInfinite || timeout > 0L)) {
                int c;
                long start = 0L;
                if (!isInfinite) {
                    start = System.currentTimeMillis();
                }
                if ((c = this.reader.read(timeout)) == -1) {
                    return -1;
                }
                if (c >= 0) {
                    int l = this.chars.limit();
                    this.chars.array()[this.chars.arrayOffset() + l] = (char)c;
                    this.chars.limit(l + 1);
                    int p = this.bytes.position();
                    l = this.bytes.limit();
                    this.bytes.position(l);
                    this.bytes.limit(this.bytes.capacity());
                    CoderResult result = this.encoder.encode(this.chars, this.bytes, false);
                    l = this.bytes.position();
                    this.bytes.position(p);
                    this.bytes.limit(l);
                    if (result.isUnderflow()) {
                        if (this.chars.limit() == this.chars.capacity()) {
                            this.chars.compact();
                            this.chars.limit(this.chars.position());
                            this.chars.position(0);
                        }
                    } else if (result.isOverflow()) {
                        if (this.bytes.limit() == this.bytes.capacity()) {
                            this.bytes.compact();
                            this.bytes.limit(this.bytes.position());
                            this.bytes.position(0);
                        }
                    } else {
                        if (result.isMalformed()) {
                            throw new MalformedInputException(result.length());
                        }
                        if (result.isUnmappable()) {
                            throw new UnmappableCharacterException(result.length());
                        }
                    }
                }
                if (isInfinite) continue;
                timeout -= System.currentTimeMillis() - start;
            }
            if (this.bytes.hasRemaining()) {
                if (isPeek) {
                    return this.bytes.get(this.bytes.position());
                }
                return this.bytes.get();
            }
            return -2;
        }
    }
}

