/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.kar.internal;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class FeatureDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureDetector.class);
    private DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    FeatureDetector() {
        this.dbf.setNamespaceAware(true);
    }

    boolean isFeaturesRepository(File artifact) {
        try {
            if (artifact.isFile() && artifact.getName().endsWith(".xml") && !artifact.getName().startsWith("maven-metadata")) {
                Document doc = this.parse(artifact);
                String name = doc.getDocumentElement().getLocalName();
                String uri = doc.getDocumentElement().getNamespaceURI();
                if ("features".equals(name) && (uri == null || "".equals(uri) || uri.startsWith("http://karaf.apache.org/xmlns/features/v"))) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("File '{}' is not a features file.", (Object)artifact.getName(), (Object)e);
        }
        return false;
    }

    private Document parse(File artifact) throws Exception {
        DocumentBuilder db = this.dbf.newDocumentBuilder();
        db.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }
        });
        return db.parse(artifact);
    }
}

