/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.command;

import java.util.Dictionary;
import org.apache.karaf.config.command.ConfigCommandSupport;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="config", name="update", description="Saves and propagates changes from the configuration being edited.")
@Service
public class UpdateCommand
extends ConfigCommandSupport {
    @Override
    protected Object doExecute() throws Exception {
        boolean isFactory;
        Dictionary props = this.getEditedProps();
        if (props == null) {
            System.err.println("No configuration is being edited--run the edit command first");
            return null;
        }
        String pid = (String)this.session.get("ConfigCommand.PID");
        boolean bl = isFactory = this.session.get("ConfigCommand.Factory") != null && (Boolean)this.session.get("ConfigCommand.Factory") != false;
        if (isFactory) {
            String alias = (String)this.session.get("ConfigCommand.Alias");
            this.configRepository.createFactoryConfiguration(pid, alias, props);
        } else {
            this.configRepository.update(pid, props);
        }
        this.session.put("ConfigCommand.PID", null);
        this.session.put("ConfigCommand.Factory", null);
        this.session.put("ConfigCommand.Props", null);
        if (this.session.get("ConfigCommand.Alias") != null) {
            this.session.put("ConfigCommand.Alias", null);
        }
        return null;
    }
}

