/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.user;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.core.MessageSendingOperations;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.user.UserDestinationResolver;
import org.springframework.messaging.simp.user.UserDestinationResult;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderInitializer;
import org.springframework.util.Assert;

public class UserDestinationMessageHandler
implements MessageHandler,
SmartLifecycle {
    private static final Log logger = LogFactory.getLog(UserDestinationMessageHandler.class);
    private final SubscribableChannel clientInboundChannel;
    private final SubscribableChannel brokerChannel;
    private final MessageSendingOperations<String> brokerMessagingTemplate;
    private final UserDestinationResolver userDestinationResolver;
    private MessageHeaderInitializer headerInitializer;
    private final Object lifecycleMonitor = new Object();
    private volatile boolean running = false;

    public UserDestinationMessageHandler(SubscribableChannel clientInChannel, SubscribableChannel brokerChannel, UserDestinationResolver userDestinationResolver) {
        Assert.notNull((Object)clientInChannel, (String)"'clientInChannel' must not be null");
        Assert.notNull((Object)brokerChannel, (String)"'brokerChannel' must not be null");
        Assert.notNull((Object)userDestinationResolver, (String)"DestinationResolver must not be null");
        this.clientInboundChannel = clientInChannel;
        this.brokerChannel = brokerChannel;
        this.brokerMessagingTemplate = new SimpMessagingTemplate(brokerChannel);
        this.userDestinationResolver = userDestinationResolver;
    }

    public MessageSendingOperations<String> getBrokerMessagingTemplate() {
        return this.brokerMessagingTemplate;
    }

    public UserDestinationResolver getUserDestinationResolver() {
        return this.userDestinationResolver;
    }

    public void setHeaderInitializer(MessageHeaderInitializer headerInitializer) {
        this.headerInitializer = headerInitializer;
    }

    public MessageHeaderInitializer getHeaderInitializer() {
        return this.headerInitializer;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public boolean isAutoStartup() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.clientInboundChannel.subscribe(this);
            this.brokerChannel.subscribe(this);
            this.running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.running = false;
            this.clientInboundChannel.unsubscribe(this);
            this.brokerChannel.unsubscribe(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.stop();
            callback.run();
        }
    }

    @Override
    public void handleMessage(Message<?> message) throws MessagingException {
        UserDestinationResult result = this.userDestinationResolver.resolveDestination(message);
        if (result == null) {
            return;
        }
        Set<String> destinations = result.getTargetDestinations();
        if (destinations.isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("No user destinations found for " + result.getSourceDestination()));
            }
            return;
        }
        if (SimpMessageType.MESSAGE.equals((Object)SimpMessageHeaderAccessor.getMessageType(message.getHeaders()))) {
            SimpMessageHeaderAccessor headerAccessor = SimpMessageHeaderAccessor.wrap(message);
            this.initHeaders(headerAccessor);
            String header = "simpOrigDestination";
            headerAccessor.setNativeHeader(header, result.getSubscribeDestination());
            message = MessageBuilder.createMessage(message.getPayload(), headerAccessor.getMessageHeaders());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Translated " + result.getSourceDestination() + " -> " + destinations));
        }
        for (String destination : destinations) {
            this.brokerMessagingTemplate.send(destination, message);
        }
    }

    private void initHeaders(SimpMessageHeaderAccessor headerAccessor) {
        if (this.getHeaderInitializer() != null) {
            this.getHeaderInitializer().initHeaders(headerAccessor);
        }
    }

    public String toString() {
        return "UserDestinationMessageHandler[" + this.userDestinationResolver + "]";
    }
}

