/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.message.Message;

public class ParameterizedMessage
implements Message {
    public static final String RECURSION_PREFIX = "[...";
    public static final String RECURSION_SUFFIX = "...]";
    public static final String ERROR_PREFIX = "[!!!";
    public static final String ERROR_SEPARATOR = "=>";
    public static final String ERROR_MSG_SEPARATOR = ":";
    public static final String ERROR_SUFFIX = "!!!]";
    private static final long serialVersionUID = -665975803997290697L;
    private static final int HASHVAL = 31;
    private static final char DELIM_START = '{';
    private static final char DELIM_STOP = '}';
    private static final char ESCAPE_CHAR = '\\';
    private final String messagePattern;
    private final String[] stringArgs;
    private transient Object[] argArray;
    private transient String formattedMessage;
    private transient Throwable throwable;

    public ParameterizedMessage(String messagePattern, String[] stringArgs, Throwable throwable) {
        this.messagePattern = messagePattern;
        this.stringArgs = stringArgs;
        this.throwable = throwable;
    }

    public ParameterizedMessage(String messagePattern, Object[] objectArgs, Throwable throwable) {
        this.messagePattern = messagePattern;
        this.throwable = throwable;
        this.stringArgs = this.argumentsToStrings(objectArgs);
    }

    public ParameterizedMessage(String messagePattern, Object[] arguments) {
        this.messagePattern = messagePattern;
        this.stringArgs = this.argumentsToStrings(arguments);
    }

    public ParameterizedMessage(String messagePattern, Object arg) {
        this(messagePattern, new Object[]{arg});
    }

    public ParameterizedMessage(String messagePattern, Object arg1, Object arg2) {
        this(messagePattern, new Object[]{arg1, arg2});
    }

    private String[] argumentsToStrings(Object[] arguments) {
        String[] strArgs;
        if (arguments == null) {
            return null;
        }
        int argsCount = ParameterizedMessage.countArgumentPlaceholders(this.messagePattern);
        int resultArgCount = arguments.length;
        if (argsCount < arguments.length && this.throwable == null && arguments[arguments.length - 1] instanceof Throwable) {
            this.throwable = (Throwable)arguments[arguments.length - 1];
            --resultArgCount;
        }
        this.argArray = new Object[resultArgCount];
        System.arraycopy(arguments, 0, this.argArray, 0, resultArgCount);
        if (argsCount == 1 && this.throwable == null && arguments.length > 1) {
            strArgs = new String[]{ParameterizedMessage.deepToString(arguments)};
        } else {
            strArgs = new String[resultArgCount];
            for (int i = 0; i < strArgs.length; ++i) {
                strArgs[i] = ParameterizedMessage.deepToString(arguments[i]);
            }
        }
        return strArgs;
    }

    @Override
    public String getFormattedMessage() {
        if (this.formattedMessage == null) {
            this.formattedMessage = this.formatMessage(this.messagePattern, this.stringArgs);
        }
        return this.formattedMessage;
    }

    @Override
    public String getFormat() {
        return this.messagePattern;
    }

    @Override
    public Object[] getParameters() {
        if (this.argArray != null) {
            return this.argArray;
        }
        return this.stringArgs;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    protected String formatMessage(String msgPattern, String[] sArgs) {
        return ParameterizedMessage.formatStringArgs(msgPattern, sArgs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterizedMessage that = (ParameterizedMessage)o;
        if (this.messagePattern != null ? !this.messagePattern.equals(that.messagePattern) : that.messagePattern != null) {
            return false;
        }
        return Arrays.equals(this.stringArgs, that.stringArgs);
    }

    public int hashCode() {
        int result = this.messagePattern != null ? this.messagePattern.hashCode() : 0;
        result = 31 * result + (this.stringArgs != null ? Arrays.hashCode(this.stringArgs) : 0);
        return result;
    }

    public static String format(String messagePattern, Object[] arguments) {
        if (messagePattern == null || arguments == null || arguments.length == 0) {
            return messagePattern;
        }
        if (arguments instanceof String[]) {
            return ParameterizedMessage.formatStringArgs(messagePattern, (String[])arguments);
        }
        String[] stringArgs = new String[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            stringArgs[i] = String.valueOf(arguments[i]);
        }
        return ParameterizedMessage.formatStringArgs(messagePattern, stringArgs);
    }

    static String formatStringArgs(String messagePattern, String[] arguments) {
        int len = 0;
        if (messagePattern == null || (len = messagePattern.length()) == 0 || arguments == null || arguments.length == 0) {
            return messagePattern;
        }
        return ParameterizedMessage.formatStringArgs0(messagePattern, len, arguments);
    }

    private static String formatStringArgs0(String messagePattern, int len, String[] arguments) {
        int i;
        char[] result = new char[len + ParameterizedMessage.sumStringLengths(arguments)];
        int pos = 0;
        int escapeCounter = 0;
        int currentArgument = 0;
        for (i = 0; i < len - 1; ++i) {
            char curChar = messagePattern.charAt(i);
            if (curChar == '\\') {
                ++escapeCounter;
                continue;
            }
            if (ParameterizedMessage.isDelimPair(curChar, messagePattern, i)) {
                ++i;
                pos = ParameterizedMessage.writeEscapedEscapeChars(escapeCounter, result, pos);
                if (ParameterizedMessage.isOdd(escapeCounter)) {
                    pos = ParameterizedMessage.writeDelimPair(result, pos);
                } else {
                    pos = ParameterizedMessage.writeArgOrDelimPair(arguments, currentArgument, result, pos);
                    ++currentArgument;
                }
            } else {
                pos = ParameterizedMessage.handleLiteralChar(result, pos, escapeCounter, curChar);
            }
            escapeCounter = 0;
        }
        pos = ParameterizedMessage.handleRemainingCharIfAny(messagePattern, len, result, pos, escapeCounter, i);
        return new String(result, 0, pos);
    }

    private static int sumStringLengths(String[] arguments) {
        int result = 0;
        for (int i = 0; i < arguments.length; ++i) {
            result += String.valueOf(arguments[i]).length();
        }
        return result;
    }

    private static boolean isDelimPair(char curChar, String messagePattern, int curCharIndex) {
        return curChar == '{' && messagePattern.charAt(curCharIndex + 1) == '}';
    }

    private static int handleRemainingCharIfAny(String messagePattern, int len, char[] result, int pos, int escapeCounter, int i) {
        if (i == len - 1) {
            char curChar = messagePattern.charAt(i);
            pos = ParameterizedMessage.handleLastChar(result, pos, escapeCounter, curChar);
        }
        return pos;
    }

    private static int handleLastChar(char[] result, int pos, int escapeCounter, char curChar) {
        pos = curChar == '\\' ? ParameterizedMessage.writeUnescapedEscapeChars(escapeCounter + 1, result, pos) : ParameterizedMessage.handleLiteralChar(result, pos, escapeCounter, curChar);
        return pos;
    }

    private static int handleLiteralChar(char[] result, int pos, int escapeCounter, char curChar) {
        pos = ParameterizedMessage.writeUnescapedEscapeChars(escapeCounter, result, pos);
        result[pos++] = curChar;
        return pos;
    }

    private static int writeDelimPair(char[] result, int pos) {
        result[pos++] = 123;
        result[pos++] = 125;
        return pos;
    }

    private static boolean isOdd(int number) {
        return (number & 1) == 1;
    }

    private static int writeEscapedEscapeChars(int escapeCounter, char[] result, int pos) {
        int escapedEscapes = escapeCounter >> 1;
        return ParameterizedMessage.writeUnescapedEscapeChars(escapedEscapes, result, pos);
    }

    private static int writeUnescapedEscapeChars(int escapeCounter, char[] result, int pos) {
        while (escapeCounter > 0) {
            result[pos++] = 92;
            --escapeCounter;
        }
        return pos;
    }

    private static int writeArgOrDelimPair(String[] arguments, int currentArgument, char[] result, int pos) {
        pos = currentArgument < arguments.length ? ParameterizedMessage.writeArgAt0(arguments, currentArgument, result, pos) : ParameterizedMessage.writeDelimPair(result, pos);
        return pos;
    }

    private static int writeArgAt0(String[] arguments, int currentArgument, char[] result, int pos) {
        String arg = String.valueOf(arguments[currentArgument]);
        int argLen = arg.length();
        arg.getChars(0, argLen, result, pos);
        return pos + argLen;
    }

    public static int countArgumentPlaceholders(String messagePattern) {
        if (messagePattern == null) {
            return 0;
        }
        int delim = messagePattern.indexOf(123);
        if (delim == -1) {
            return 0;
        }
        int result = 0;
        boolean isEscaped = false;
        for (int i = 0; i < messagePattern.length(); ++i) {
            char curChar = messagePattern.charAt(i);
            if (curChar == '\\') {
                isEscaped = !isEscaped;
                continue;
            }
            if (curChar == '{') {
                if (!isEscaped && i < messagePattern.length() - 1 && messagePattern.charAt(i + 1) == '}') {
                    ++result;
                    ++i;
                }
                isEscaped = false;
                continue;
            }
            isEscaped = false;
        }
        return result;
    }

    public static String deepToString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        StringBuilder str = new StringBuilder();
        HashSet<String> dejaVu = new HashSet<String>();
        ParameterizedMessage.recursiveDeepToString(o, str, dejaVu);
        return str.toString();
    }

    private static void recursiveDeepToString(Object o, StringBuilder str, Set<String> dejaVu) {
        if (ParameterizedMessage.appendStringDateOrNull(o, str)) {
            return;
        }
        if (ParameterizedMessage.isMaybeRecursive(o)) {
            ParameterizedMessage.appendPotentiallyRecursiveValue(o, str, dejaVu);
        } else {
            ParameterizedMessage.tryObjectToString(o, str);
        }
    }

    private static boolean appendStringDateOrNull(Object o, StringBuilder str) {
        if (o == null || o instanceof String) {
            str.append(String.valueOf(o));
            return true;
        }
        return ParameterizedMessage.appendDate(o, str);
    }

    private static boolean appendDate(Object o, StringBuilder str) {
        if (!(o instanceof Date)) {
            return false;
        }
        Date date = (Date)o;
        SimpleDateFormat format = ParameterizedMessage.getSimpleDateFormat();
        str.append(format.format(date));
        return true;
    }

    private static SimpleDateFormat getSimpleDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    }

    private static boolean isMaybeRecursive(Object o) {
        return o.getClass().isArray() || o instanceof Map || o instanceof Collection;
    }

    private static void appendPotentiallyRecursiveValue(Object o, StringBuilder str, Set<String> dejaVu) {
        Class<?> oClass = o.getClass();
        if (oClass.isArray()) {
            ParameterizedMessage.appendArray(o, str, dejaVu, oClass);
        } else if (o instanceof Map) {
            ParameterizedMessage.appendMap(o, str, dejaVu);
        } else if (o instanceof Collection) {
            ParameterizedMessage.appendCollection(o, str, dejaVu);
        }
    }

    private static void appendArray(Object o, StringBuilder str, Set<String> dejaVu, Class<?> oClass) {
        if (oClass == byte[].class) {
            str.append(Arrays.toString((byte[])o));
        } else if (oClass == short[].class) {
            str.append(Arrays.toString((short[])o));
        } else if (oClass == int[].class) {
            str.append(Arrays.toString((int[])o));
        } else if (oClass == long[].class) {
            str.append(Arrays.toString((long[])o));
        } else if (oClass == float[].class) {
            str.append(Arrays.toString((float[])o));
        } else if (oClass == double[].class) {
            str.append(Arrays.toString((double[])o));
        } else if (oClass == boolean[].class) {
            str.append(Arrays.toString((boolean[])o));
        } else if (oClass == char[].class) {
            str.append(Arrays.toString((char[])o));
        } else {
            String id = ParameterizedMessage.identityToString(o);
            if (dejaVu.contains(id)) {
                str.append(RECURSION_PREFIX).append(id).append(RECURSION_SUFFIX);
            } else {
                dejaVu.add(id);
                Object[] oArray = (Object[])o;
                str.append('[');
                boolean first = true;
                for (Object current : oArray) {
                    if (first) {
                        first = false;
                    } else {
                        str.append(", ");
                    }
                    ParameterizedMessage.recursiveDeepToString(current, str, new HashSet<String>(dejaVu));
                }
                str.append(']');
            }
        }
    }

    private static void appendMap(Object o, StringBuilder str, Set<String> dejaVu) {
        String id = ParameterizedMessage.identityToString(o);
        if (dejaVu.contains(id)) {
            str.append(RECURSION_PREFIX).append(id).append(RECURSION_SUFFIX);
        } else {
            dejaVu.add(id);
            Map oMap = (Map)o;
            str.append('{');
            boolean isFirst = true;
            Iterator i$ = oMap.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o1;
                Map.Entry current = o1 = i$.next();
                if (isFirst) {
                    isFirst = false;
                } else {
                    str.append(", ");
                }
                Object key = current.getKey();
                Object value = current.getValue();
                ParameterizedMessage.recursiveDeepToString(key, str, new HashSet<String>(dejaVu));
                str.append('=');
                ParameterizedMessage.recursiveDeepToString(value, str, new HashSet<String>(dejaVu));
            }
            str.append('}');
        }
    }

    private static void appendCollection(Object o, StringBuilder str, Set<String> dejaVu) {
        String id = ParameterizedMessage.identityToString(o);
        if (dejaVu.contains(id)) {
            str.append(RECURSION_PREFIX).append(id).append(RECURSION_SUFFIX);
        } else {
            dejaVu.add(id);
            Collection oCol = (Collection)o;
            str.append('[');
            boolean isFirst = true;
            for (Object anOCol : oCol) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    str.append(", ");
                }
                ParameterizedMessage.recursiveDeepToString(anOCol, str, new HashSet<String>(dejaVu));
            }
            str.append(']');
        }
    }

    private static void tryObjectToString(Object o, StringBuilder str) {
        try {
            str.append(o.toString());
        }
        catch (Throwable t) {
            ParameterizedMessage.handleErrorInObjectToString(o, str, t);
        }
    }

    private static void handleErrorInObjectToString(Object o, StringBuilder str, Throwable t) {
        str.append(ERROR_PREFIX);
        str.append(ParameterizedMessage.identityToString(o));
        str.append(ERROR_SEPARATOR);
        String msg = t.getMessage();
        String className = t.getClass().getName();
        str.append(className);
        if (!className.equals(msg)) {
            str.append(ERROR_MSG_SEPARATOR);
            str.append(msg);
        }
        str.append(ERROR_SUFFIX);
    }

    public static String identityToString(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(obj));
    }

    public String toString() {
        return "ParameterizedMessage[messagePattern=" + this.messagePattern + ", stringArgs=" + Arrays.toString(this.stringArgs) + ", throwable=" + this.throwable + ']';
    }
}

