/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Function;
import org.apache.karaf.shell.api.console.Session;

@Command(scope="shell", name="if", description="If/Then/Else block.")
@Service
public class IfAction
implements Action {
    @Argument(name="condition", index=0, multiValued=false, required=true, description="The condition")
    Function condition;
    @Argument(name="ifTrue", index=1, multiValued=false, required=true, description="The function to execute if the condition is true")
    Function ifTrue;
    @Argument(name="ifFalse", index=2, multiValued=false, required=false, description="The function to execute if the condition is false")
    Function ifFalse;
    @Reference
    Session session;

    public Object execute() throws Exception {
        Object result = this.condition.execute(this.session, null);
        if (this.isTrue(result)) {
            return this.ifTrue.execute(this.session, null);
        }
        if (this.ifFalse != null) {
            return this.ifFalse.execute(this.session, null);
        }
        return null;
    }

    private boolean isTrue(Object result) {
        if (result == null) {
            return false;
        }
        if (result instanceof String && ((String)result).equals("")) {
            return false;
        }
        if (result instanceof Number) {
            return ((Number)result).doubleValue() != 0.0;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return true;
    }
}

