/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.karaf.shell.api.action.lifecycle.Manager;
import org.apache.karaf.shell.api.console.CommandLoggingFilter;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.ssh.KarafAgentFactory;
import org.apache.karaf.shell.ssh.KarafFileSystemFactory;
import org.apache.karaf.shell.ssh.KarafJaasAuthenticator;
import org.apache.karaf.shell.ssh.OpenSSHGeneratorFileKeyProvider;
import org.apache.karaf.shell.ssh.ShellCommandFactory;
import org.apache.karaf.shell.ssh.ShellFactoryImpl;
import org.apache.karaf.shell.ssh.SshAction;
import org.apache.karaf.shell.ssh.SshUtils;
import org.apache.karaf.shell.ssh.UserAuthFactoriesFactory;
import org.apache.karaf.shell.support.RegexCommandLoggingFilter;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.Managed;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.apache.sshd.SshServer;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.command.ScpCommandFactory;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.sftp.SftpSubsystem;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Services(requires={@RequireService(value=SessionFactory.class)})
@Managed(value="org.apache.karaf.shell")
public class Activator
extends BaseActivator
implements ManagedService {
    static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    ServiceTracker<Session, Session> sessionTracker;
    KarafAgentFactory agentFactory;
    SessionFactory sessionFactory;
    SshServer server;

    @Override
    protected void doOpen() throws Exception {
        this.agentFactory = new KarafAgentFactory();
        super.doOpen();
        this.sessionTracker = new ServiceTracker<Session, Session>(this.bundleContext, Session.class, null){

            public Session addingService(ServiceReference<Session> reference) {
                Session session = (Session)super.addingService(reference);
                Activator.this.agentFactory.registerSession(session);
                return session;
            }

            public void removedService(ServiceReference<Session> reference, Session session) {
                Activator.this.agentFactory.unregisterSession(session);
                super.removedService(reference, (Object)session);
            }
        };
        this.sessionTracker.open();
    }

    @Override
    protected void doClose() {
        this.sessionTracker.close();
        super.doClose();
    }

    @Override
    protected void doStart() throws Exception {
        SessionFactory sf = this.getTrackedService(SessionFactory.class);
        if (sf == null) {
            return;
        }
        RegexCommandLoggingFilter filter = new RegexCommandLoggingFilter();
        filter.setPattern("ssh (.*?)-P +([^ ]+)");
        filter.setGroup(2);
        this.register(CommandLoggingFilter.class, filter);
        filter = new RegexCommandLoggingFilter();
        filter.setPattern("ssh (.*?)--password +([^ ]+)");
        filter.setGroup(2);
        this.register(CommandLoggingFilter.class, filter);
        this.sessionFactory = sf;
        ((Manager)this.sessionFactory.getRegistry().getService(Manager.class)).register(SshAction.class);
        if (Boolean.parseBoolean(this.bundleContext.getProperty("karaf.startRemoteShell"))) {
            this.server = this.createSshServer(this.sessionFactory);
            this.bundleContext.registerService(SshServer.class, (Object)this.server, null);
            if (this.server == null) {
                return;
            }
            try {
                this.server.start();
            }
            catch (IOException e) {
                LOGGER.warn("Exception caught while starting SSH server", (Throwable)e);
            }
        }
    }

    @Override
    protected void doStop() {
        if (this.sessionFactory != null) {
            ((Manager)this.sessionFactory.getRegistry().getService(Manager.class)).unregister(SshAction.class);
            this.sessionFactory = null;
        }
        if (this.server != null) {
            try {
                this.server.stop(true);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Exception caught while stopping SSH server", (Throwable)e);
            }
            this.server = null;
        }
        super.doStop();
    }

    protected SshServer createSshServer(SessionFactory sessionFactory) {
        Object keyPairProvider;
        int sshPort = this.getInt("sshPort", 8181);
        String sshHost = this.getString("sshHost", "0.0.0.0");
        long sshIdleTimeout = this.getLong("sshIdleTimeout", 1800000L);
        String sshRealm = this.getString("sshRealm", "karaf");
        String hostKey = this.getString("hostKey", System.getProperty("karaf.etc") + "/host.key");
        String hostKeyFormat = this.getString("hostKeyFormat", "simple");
        String authMethods = this.getString("authMethods", "keyboard-interactive,password,publickey");
        int keySize = this.getInt("keySize", 4096);
        String algorithm = this.getString("algorithm", "RSA");
        String macs = this.getString("macs", "hmac-sha1");
        String ciphers = this.getString("ciphers", "aes256-ctr,aes192-ctr,aes128-ctr,arcfour256");
        String welcomeBanner = this.getString("welcomeBanner", null);
        if ("simple".equalsIgnoreCase(hostKeyFormat)) {
            keyPairProvider = new SimpleGeneratorHostKeyProvider();
        } else if ("PEM".equalsIgnoreCase(hostKeyFormat)) {
            keyPairProvider = new OpenSSHGeneratorFileKeyProvider();
        } else {
            LOGGER.error("Invalid host key format " + hostKeyFormat);
            return null;
        }
        keyPairProvider.setPath(hostKey);
        if (new File(hostKey).exists()) {
            keyPairProvider.setOverwriteAllowed(false);
        } else {
            keyPairProvider.setKeySize(keySize);
            keyPairProvider.setAlgorithm(algorithm);
        }
        KarafJaasAuthenticator authenticator = new KarafJaasAuthenticator(sshRealm);
        UserAuthFactoriesFactory authFactoriesFactory = new UserAuthFactoriesFactory();
        authFactoriesFactory.setAuthMethods(authMethods);
        SshServer server = SshServer.setUpDefaultServer();
        server.setPort(sshPort);
        server.setHost(sshHost);
        server.setMacFactories(SshUtils.buildMacs(macs));
        server.setCipherFactories(SshUtils.buildCiphers(ciphers));
        server.setShellFactory((Factory)new ShellFactoryImpl(sessionFactory));
        server.setCommandFactory((CommandFactory)new ScpCommandFactory((CommandFactory)new ShellCommandFactory(sessionFactory)));
        server.setSubsystemFactories(Arrays.asList(new SftpSubsystem.Factory()));
        server.setKeyPairProvider((KeyPairProvider)keyPairProvider);
        server.setPasswordAuthenticator((PasswordAuthenticator)authenticator);
        server.setPublickeyAuthenticator((PublickeyAuthenticator)authenticator);
        server.setFileSystemFactory((FileSystemFactory)new KarafFileSystemFactory());
        server.setUserAuthFactories(authFactoriesFactory.getFactories());
        server.setAgentFactory((SshAgentFactory)this.agentFactory);
        server.getProperties().put("idle-timeout", Long.toString(sshIdleTimeout));
        if (welcomeBanner != null) {
            server.getProperties().put("welcome-banner", welcomeBanner);
        }
        return server;
    }
}

