/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd;

import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.sshd.SshClient;
import org.apache.sshd.SshServer;
import org.apache.sshd.client.ServerKeyVerifier;
import org.apache.sshd.client.kex.DHG1;
import org.apache.sshd.client.kex.DHG14;
import org.apache.sshd.client.kex.DHGEX;
import org.apache.sshd.client.kex.DHGEX256;
import org.apache.sshd.client.kex.ECDHP256;
import org.apache.sshd.client.kex.ECDHP384;
import org.apache.sshd.client.kex.ECDHP521;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.common.AbstractFactoryManager;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.Cipher;
import org.apache.sshd.common.Compression;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.KeyExchange;
import org.apache.sshd.common.Mac;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Random;
import org.apache.sshd.common.RequestHandler;
import org.apache.sshd.common.Signature;
import org.apache.sshd.common.TcpipForwarderFactory;
import org.apache.sshd.common.cipher.AES128CBC;
import org.apache.sshd.common.cipher.AES128CTR;
import org.apache.sshd.common.cipher.AES192CBC;
import org.apache.sshd.common.cipher.AES192CTR;
import org.apache.sshd.common.cipher.AES256CBC;
import org.apache.sshd.common.cipher.AES256CTR;
import org.apache.sshd.common.cipher.ARCFOUR128;
import org.apache.sshd.common.cipher.ARCFOUR256;
import org.apache.sshd.common.cipher.BlowfishCBC;
import org.apache.sshd.common.cipher.TripleDESCBC;
import org.apache.sshd.common.compression.CompressionNone;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.nativefs.NativeFileSystemFactory;
import org.apache.sshd.common.forward.DefaultTcpipForwarderFactory;
import org.apache.sshd.common.forward.TcpipServerChannel;
import org.apache.sshd.common.mac.HMACMD5;
import org.apache.sshd.common.mac.HMACMD596;
import org.apache.sshd.common.mac.HMACSHA1;
import org.apache.sshd.common.mac.HMACSHA196;
import org.apache.sshd.common.mac.HMACSHA256;
import org.apache.sshd.common.mac.HMACSHA512;
import org.apache.sshd.common.random.BouncyCastleRandom;
import org.apache.sshd.common.random.JceRandom;
import org.apache.sshd.common.random.SingletonRandomFactory;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.signature.SignatureDSA;
import org.apache.sshd.common.signature.SignatureECDSA;
import org.apache.sshd.common.signature.SignatureRSA;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.global.CancelTcpipForwardHandler;
import org.apache.sshd.server.global.KeepAliveHandler;
import org.apache.sshd.server.global.NoMoreSessionsHandler;
import org.apache.sshd.server.global.TcpipForwardHandler;
import org.apache.sshd.server.kex.DHG1;
import org.apache.sshd.server.kex.DHG14;
import org.apache.sshd.server.kex.DHGEX;
import org.apache.sshd.server.kex.DHGEX256;
import org.apache.sshd.server.kex.ECDHP256;
import org.apache.sshd.server.kex.ECDHP384;
import org.apache.sshd.server.kex.ECDHP521;

public class SshBuilder {
    public static ClientBuilder client() {
        return new ClientBuilder();
    }

    public static ServerBuilder server() {
        return new ServerBuilder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ServerBuilder
    extends BaseBuilder<SshServer, ServerBuilder> {
        @Override
        protected ServerBuilder fillWithDefaultValues() {
            super.fillWithDefaultValues();
            if (SecurityUtils.isBouncyCastleRegistered()) {
                if (this.keyExchangeFactories == null) {
                    this.keyExchangeFactories = Arrays.asList(new DHGEX256.Factory(), new DHGEX.Factory(), new ECDHP256.Factory(), new ECDHP384.Factory(), new ECDHP521.Factory(), new DHG14.Factory(), new DHG1.Factory());
                }
            } else if (SecurityUtils.hasEcc()) {
                if (this.keyExchangeFactories == null) {
                    this.keyExchangeFactories = Arrays.asList(new DHGEX256.Factory(), new DHGEX.Factory(), new ECDHP256.Factory(), new ECDHP384.Factory(), new ECDHP521.Factory(), new DHG1.Factory());
                }
            } else if (this.keyExchangeFactories == null) {
                this.keyExchangeFactories = Arrays.asList(new DHGEX256.Factory(), new DHGEX.Factory(), new DHG1.Factory());
            }
            if (this.channelFactories == null) {
                this.channelFactories = Arrays.asList(new ChannelSession.Factory(), new TcpipServerChannel.DirectTcpipFactory());
            }
            if (this.globalRequestHandlers == null) {
                this.globalRequestHandlers = Arrays.asList(new KeepAliveHandler(), new NoMoreSessionsHandler(), new TcpipForwardHandler(), new CancelTcpipForwardHandler());
            }
            if (this.factory == null) {
                this.factory = SshServer.DEFAULT_SSH_SERVER_FACTORY;
            }
            return (ServerBuilder)this.me();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClientBuilder
    extends BaseBuilder<SshClient, ClientBuilder> {
        protected ServerKeyVerifier serverKeyVerifier;

        public ClientBuilder serverKeyVerifier(ServerKeyVerifier serverKeyVerifier) {
            this.serverKeyVerifier = serverKeyVerifier;
            return (ClientBuilder)this.me();
        }

        @Override
        protected ClientBuilder fillWithDefaultValues() {
            super.fillWithDefaultValues();
            if (SecurityUtils.isBouncyCastleRegistered()) {
                if (this.keyExchangeFactories == null) {
                    this.keyExchangeFactories = Arrays.asList(new DHGEX256.Factory(), new DHGEX.Factory(), new ECDHP256.Factory(), new ECDHP384.Factory(), new ECDHP521.Factory(), new DHG14.Factory(), new DHG1.Factory());
                }
            } else if (SecurityUtils.hasEcc()) {
                if (this.keyExchangeFactories == null) {
                    this.keyExchangeFactories = Arrays.asList(new DHGEX256.Factory(), new DHGEX.Factory(), new ECDHP256.Factory(), new ECDHP384.Factory(), new ECDHP521.Factory(), new DHG1.Factory());
                }
            } else if (this.keyExchangeFactories == null) {
                this.keyExchangeFactories = Arrays.asList(new DHGEX256.Factory(), new DHGEX.Factory(), new DHG1.Factory());
            }
            if (this.channelFactories == null) {
                this.channelFactories = Arrays.asList(new TcpipServerChannel.ForwardedTcpipFactory());
            }
            if (this.serverKeyVerifier == null) {
                this.serverKeyVerifier = AcceptAllServerKeyVerifier.INSTANCE;
            }
            if (this.factory == null) {
                this.factory = SshClient.DEFAULT_SSH_CLIENT_FACTORY;
            }
            return (ClientBuilder)this.me();
        }

        @Override
        public SshClient build(boolean isFillWithDefaultValues) {
            SshClient client = (SshClient)super.build(isFillWithDefaultValues);
            client.setServerKeyVerifier(this.serverKeyVerifier);
            return client;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class BaseBuilder<T extends AbstractFactoryManager, S extends BaseBuilder<T, S>> {
        protected Factory<T> factory = null;
        protected List<NamedFactory<KeyExchange>> keyExchangeFactories = null;
        protected List<NamedFactory<Cipher>> cipherFactories = null;
        protected List<NamedFactory<Compression>> compressionFactories = null;
        protected List<NamedFactory<Mac>> macFactories = null;
        protected List<NamedFactory<Signature>> signatureFactories = null;
        protected Factory<Random> randomFactory = null;
        protected List<NamedFactory<Channel>> channelFactories = null;
        protected FileSystemFactory fileSystemFactory = null;
        protected TcpipForwarderFactory tcpipForwarderFactory = null;
        protected List<RequestHandler<ConnectionService>> globalRequestHandlers = null;

        protected BaseBuilder() {
        }

        protected S fillWithDefaultValues() {
            if (SecurityUtils.isBouncyCastleRegistered()) {
                if (this.signatureFactories == null) {
                    this.signatureFactories = Arrays.asList(new SignatureECDSA.NISTP256Factory(), new SignatureECDSA.NISTP384Factory(), new SignatureECDSA.NISTP521Factory(), new SignatureDSA.Factory(), new SignatureRSA.Factory());
                }
                if (this.randomFactory == null) {
                    this.randomFactory = new SingletonRandomFactory(new BouncyCastleRandom.Factory());
                }
            } else if (SecurityUtils.hasEcc()) {
                if (this.signatureFactories == null) {
                    this.signatureFactories = Arrays.asList(new SignatureECDSA.NISTP256Factory(), new SignatureECDSA.NISTP384Factory(), new SignatureECDSA.NISTP521Factory(), new SignatureDSA.Factory(), new SignatureRSA.Factory());
                }
                if (this.randomFactory == null) {
                    this.randomFactory = new SingletonRandomFactory(new JceRandom.Factory());
                }
            } else {
                if (this.signatureFactories == null) {
                    this.signatureFactories = Arrays.asList(new SignatureDSA.Factory(), new SignatureRSA.Factory());
                }
                if (this.randomFactory == null) {
                    this.randomFactory = new SingletonRandomFactory(new JceRandom.Factory());
                }
            }
            if (this.cipherFactories == null) {
                this.cipherFactories = BaseBuilder.setUpDefaultCiphers();
            }
            if (this.compressionFactories == null) {
                this.compressionFactories = Arrays.asList(new CompressionNone.Factory());
            }
            if (this.macFactories == null) {
                this.macFactories = Arrays.asList(new HMACSHA256.Factory(), new HMACSHA512.Factory(), new HMACSHA1.Factory(), new HMACMD5.Factory(), new HMACSHA196.Factory(), new HMACMD596.Factory());
            }
            if (this.fileSystemFactory == null) {
                this.fileSystemFactory = new NativeFileSystemFactory();
            }
            if (this.tcpipForwarderFactory == null) {
                this.tcpipForwarderFactory = new DefaultTcpipForwarderFactory();
            }
            return this.me();
        }

        public S keyExchangeFactories(List<NamedFactory<KeyExchange>> keyExchangeFactories) {
            this.keyExchangeFactories = keyExchangeFactories;
            return this.me();
        }

        public S signatureFactories(List<NamedFactory<Signature>> signatureFactories) {
            this.signatureFactories = signatureFactories;
            return this.me();
        }

        public S randomFactory(Factory<Random> randomFactory) {
            this.randomFactory = randomFactory;
            return this.me();
        }

        public S cipherFactories(List<NamedFactory<Cipher>> cipherFactories) {
            this.cipherFactories = cipherFactories;
            return this.me();
        }

        public S compressionFactories(List<NamedFactory<Compression>> compressionFactories) {
            this.compressionFactories = compressionFactories;
            return this.me();
        }

        public S macFactories(List<NamedFactory<Mac>> macFactories) {
            this.macFactories = macFactories;
            return this.me();
        }

        public S channelFactories(List<NamedFactory<Channel>> channelFactories) {
            this.channelFactories = channelFactories;
            return this.me();
        }

        public S fileSystemFactory(FileSystemFactory fileSystemFactory) {
            this.fileSystemFactory = fileSystemFactory;
            return this.me();
        }

        public S tcpipForwarderFactory(TcpipForwarderFactory tcpipForwarderFactory) {
            this.tcpipForwarderFactory = tcpipForwarderFactory;
            return this.me();
        }

        public S globalRequestHandlers(List<RequestHandler<ConnectionService>> globalRequestHandlers) {
            this.globalRequestHandlers = globalRequestHandlers;
            return this.me();
        }

        public S factory(Factory<T> factory) {
            this.factory = factory;
            return this.me();
        }

        public T build(boolean isFillWithDefaultValues) {
            if (isFillWithDefaultValues) {
                this.fillWithDefaultValues();
            }
            AbstractFactoryManager ssh = (AbstractFactoryManager)this.factory.create();
            ssh.setKeyExchangeFactories(this.keyExchangeFactories);
            ssh.setSignatureFactories(this.signatureFactories);
            ssh.setRandomFactory(this.randomFactory);
            ssh.setCipherFactories(this.cipherFactories);
            ssh.setCompressionFactories(this.compressionFactories);
            ssh.setMacFactories(this.macFactories);
            ssh.setChannelFactories(this.channelFactories);
            ssh.setFileSystemFactory(this.fileSystemFactory);
            ssh.setTcpipForwarderFactory(this.tcpipForwarderFactory);
            ssh.setGlobalRequestHandlers(this.globalRequestHandlers);
            return (T)ssh;
        }

        public T build() {
            return this.build(true);
        }

        protected S me() {
            return (S)this;
        }

        protected static List<NamedFactory<Cipher>> setUpDefaultCiphers() {
            LinkedList<NamedFactory<Cipher>> avail = new LinkedList<NamedFactory<Cipher>>();
            avail.add(new AES128CTR.Factory());
            avail.add(new AES192CTR.Factory());
            avail.add(new AES256CTR.Factory());
            avail.add(new ARCFOUR128.Factory());
            avail.add(new ARCFOUR256.Factory());
            avail.add(new AES128CBC.Factory());
            avail.add(new TripleDESCBC.Factory());
            avail.add(new BlowfishCBC.Factory());
            avail.add(new AES192CBC.Factory());
            avail.add(new AES256CBC.Factory());
            Iterator i = avail.iterator();
            while (i.hasNext()) {
                NamedFactory f = (NamedFactory)i.next();
                try {
                    Cipher c = (Cipher)f.create();
                    byte[] key = new byte[c.getBlockSize()];
                    byte[] iv = new byte[c.getIVSize()];
                    c.init(Cipher.Mode.Encrypt, key, iv);
                }
                catch (InvalidKeyException e) {
                    i.remove();
                }
                catch (Exception e) {
                    i.remove();
                }
            }
            return avail;
        }
    }
}

