/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging;

import java.util.HashMap;
import java.util.Map;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.internal.BundleHelper;
import org.ops4j.pax.logging.internal.TrackingLogger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class OSGIPaxLoggingManager
extends ServiceTracker
implements PaxLoggingManager {
    private PaxLoggingService m_service;
    private BundleContext m_context;
    private Map<String, TrackingLogger> m_loggers = new HashMap<String, TrackingLogger>();
    private ServiceReference m_logServiceRef;

    public OSGIPaxLoggingManager(BundleContext context) {
        super(context, PaxLoggingService.class.getName(), null);
        this.m_context = context;
        ServiceReference ref = context.getServiceReference(PaxLoggingService.class.getName());
        if (ref != null) {
            this.m_service = (PaxLoggingService)context.getService(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference reference) {
        this.m_logServiceRef = reference;
        this.m_service = (PaxLoggingService)this.m_context.getService(reference);
        Map<String, TrackingLogger> map = this.m_loggers;
        synchronized (map) {
            for (TrackingLogger logger : this.m_loggers.values()) {
                logger.added(this.m_service);
            }
        }
        return this.m_service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference reference, Object service) {
        this.m_service = null;
        if (this.m_logServiceRef == null) {
            this.m_context.ungetService(this.m_logServiceRef);
            this.m_logServiceRef = null;
        }
        Map<String, TrackingLogger> map = this.m_loggers;
        synchronized (map) {
            for (TrackingLogger logger : this.m_loggers.values()) {
                logger.removed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PaxLogger getLogger(String category, String fqcn) {
        if (fqcn == null) {
            fqcn = PaxLogger.class.getName();
        }
        Bundle bundle = BundleHelper.getCallerBundle(this.m_context.getBundle());
        String key = fqcn + "#" + category + "#" + (bundle != null ? Long.toString(bundle.getBundleId()) : "0");
        Map<String, TrackingLogger> map = this.m_loggers;
        synchronized (map) {
            TrackingLogger logger = this.m_loggers.get(key);
            if (logger == null) {
                logger = new TrackingLogger(this.m_service, category, bundle, fqcn);
                this.m_loggers.put(key, logger);
            }
            return logger;
        }
    }

    @Override
    public PaxLoggingService getPaxLoggingService() {
        return this.m_service;
    }

    @Override
    public void dispose() {
        if (this.m_logServiceRef != null) {
            this.m_context.ungetService(this.m_logServiceRef);
            this.m_logServiceRef = null;
        }
        this.m_context = null;
    }

    @Override
    public Bundle getBundle() {
        return this.m_context.getBundle();
    }
}

