/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.internal.signedcontent.SignedBundleHook;
import org.eclipse.osgi.internal.signedcontent.SignedContentImpl;
import org.eclipse.osgi.internal.signedcontent.SignedStorageHook;
import org.eclipse.osgi.internal.signedcontent.SignerInfoImpl;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.storage.BundleInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class TrustEngineListener {
    private final BundleContext context;
    private final SignedBundleHook signedBundleHook;

    TrustEngineListener(BundleContext context, SignedBundleHook signedBundleHook) {
        this.context = context;
        this.signedBundleHook = signedBundleHook;
    }

    public void addedTrustAnchor(Certificate anchor) {
        Bundle[] bundles = this.context.getBundles();
        int i = 0;
        while (i < bundles.length) {
            SignedContentImpl signedContent = this.getSignedContent(bundles[i]);
            if (signedContent != null && signedContent.isSigned()) {
                SignerInfo[] infos = signedContent.getSignerInfos();
                int j = 0;
                while (j < infos.length) {
                    if (infos[j].getTrustAnchor() == null) {
                        this.signedBundleHook.determineTrust(signedContent, 2);
                    } else {
                        SignerInfo tsa = signedContent.getTSASignerInfo(infos[j]);
                        if (tsa != null && tsa.getTrustAnchor() == null) {
                            this.signedBundleHook.determineTrust(signedContent, 2);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void removedTrustAnchor(Certificate anchor) {
        Bundle[] bundles = this.context.getBundles();
        HashSet<Bundle> usingAnchor = new HashSet<Bundle>();
        HashSet<SignerInfo> untrustedSigners = new HashSet<SignerInfo>();
        int i = 0;
        while (i < bundles.length) {
            SignedContentImpl signedContent = this.getSignedContent(bundles[i]);
            if (signedContent != null && signedContent.isSigned()) {
                SignerInfo[] infos = signedContent.getSignerInfos();
                int j = 0;
                while (j < infos.length) {
                    SignerInfo tsa;
                    if (anchor.equals(infos[j].getTrustAnchor())) {
                        untrustedSigners.add(infos[j]);
                        usingAnchor.add(bundles[i]);
                    }
                    if ((tsa = signedContent.getTSASignerInfo(infos[j])) != null && anchor.equals(tsa.getTrustAnchor())) {
                        usingAnchor.add(bundles[i]);
                        untrustedSigners.add(tsa);
                    }
                    ++j;
                }
            }
            ++i;
        }
        Iterator untrusted = untrustedSigners.iterator();
        while (untrusted.hasNext()) {
            ((SignerInfoImpl)untrusted.next()).setTrustAnchor(null);
        }
        for (Bundle bundle : usingAnchor) {
            SignedContentImpl signedContent = this.getSignedContent(bundle);
            this.signedBundleHook.determineTrust(signedContent, 2);
        }
    }

    private SignedContentImpl getSignedContent(Bundle bundle) {
        BundleInfo.Generation generation = (BundleInfo.Generation)((EquinoxBundle)bundle).getModule().getCurrentRevision().getRevisionInfo();
        SignedStorageHook.StorageHookImpl hook = (SignedStorageHook.StorageHookImpl)generation.getStorageHook(SignedStorageHook.class);
        return hook != null ? hook.signedContent : null;
    }
}

