/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.resource;

import aQute.bnd.header.Attrs;
import aQute.bnd.osgi.resource.CapabilityImpl;
import aQute.bnd.osgi.resource.Filters;
import aQute.bnd.osgi.resource.RequirementImpl;
import aQute.bnd.version.VersionRange;
import aQute.libg.filters.AndFilter;
import aQute.libg.filters.Filter;
import aQute.libg.filters.LiteralFilter;
import aQute.libg.filters.SimpleFilter;
import java.util.HashMap;
import java.util.Map;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapReqBuilder {
    private final String namespace;
    private Resource resource;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Map<String, String> directives = new HashMap<String, String>();

    public CapReqBuilder(String namespace) {
        this.namespace = namespace;
    }

    public CapReqBuilder(String ns, Attrs attrs) {
        this.namespace = ns;
        for (Map.Entry<String, String> entry : attrs.entrySet()) {
            String key = entry.getKey();
            if (key.endsWith(":")) {
                this.addDirective(key.substring(0, key.length() - 1), entry.getValue());
                continue;
            }
            this.addAttribute(key, entry.getValue());
        }
    }

    public static CapReqBuilder clone(Capability capability) {
        CapReqBuilder builder = new CapReqBuilder(capability.getNamespace());
        builder.addAttributes(capability.getAttributes());
        builder.addDirectives(capability.getDirectives());
        return builder;
    }

    public static CapReqBuilder clone(Requirement requirement) {
        CapReqBuilder builder = new CapReqBuilder(requirement.getNamespace());
        builder.addAttributes(requirement.getAttributes());
        builder.addDirectives(requirement.getDirectives());
        return builder;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public CapReqBuilder setResource(Resource resource) {
        this.resource = resource;
        return this;
    }

    public CapReqBuilder addAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, value);
        }
        return this;
    }

    public CapReqBuilder addAttributes(Map<? extends String, ? extends Object> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    public CapReqBuilder addDirective(String name, String value) {
        if (value != null) {
            this.directives.put(name, value);
        }
        return this;
    }

    public CapReqBuilder addDirectives(Map<? extends String, ? extends String> directives) {
        this.directives.putAll(directives);
        return this;
    }

    public Capability buildCapability() {
        return new CapabilityImpl(this.namespace, this.resource, this.directives, this.attributes);
    }

    public Requirement buildRequirement() {
        return new RequirementImpl(this.namespace, this.resource, this.directives, this.attributes);
    }

    public Requirement buildSyntheticRequirement() {
        return new RequirementImpl(this.namespace, null, this.directives, this.attributes);
    }

    public static final CapReqBuilder createPackageRequirement(String pkgName, String range) {
        SimpleFilter pkgNameFilter = new SimpleFilter("osgi.wiring.package", pkgName);
        Filter filter = range != null ? new AndFilter().addChild(pkgNameFilter).addChild(new LiteralFilter(Filters.fromVersionRange(range))) : pkgNameFilter;
        return new CapReqBuilder("osgi.wiring.package").addDirective("filter", filter.toString());
    }

    public static CapReqBuilder createBundleRequirement(String bsn, String range) {
        SimpleFilter bsnFilter = new SimpleFilter("osgi.identity", bsn);
        Filter filter = range != null ? new AndFilter().addChild(bsnFilter).addChild(new LiteralFilter(Filters.fromVersionRange(range))) : bsnFilter;
        return new CapReqBuilder("osgi.identity").addDirective("filter", filter.toString());
    }

    public CharSequence and(Object ... exprs) {
        StringBuilder sb = new StringBuilder();
        sb.append("(&");
        for (Object expr : exprs) {
            sb.append("(").append(this.toFilter(expr)).append(")");
        }
        sb.append(")");
        return sb;
    }

    public CharSequence or(Object ... exprs) {
        StringBuilder sb = new StringBuilder();
        sb.append("(|");
        for (Object expr : exprs) {
            sb.append("(").append(this.toFilter(expr)).append(")");
        }
        sb.append(")");
        return sb;
    }

    public CharSequence not(Object expr) {
        StringBuilder sb = new StringBuilder();
        sb.append("(!(").append(this.toFilter(expr)).append(")");
        return sb;
    }

    private CharSequence toFilter(Object expr) {
        if (expr instanceof CharSequence) {
            return (CharSequence)expr;
        }
        if (expr instanceof Filter) {
            return expr.toString();
        }
        if (expr instanceof VersionRange) {
            return ((VersionRange)expr).toFilter();
        }
        return expr.toString();
    }

    public CapReqBuilder filter(CharSequence f) {
        return this.addDirective("filter", f.toString());
    }
}

