/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.artifact.Artifact;
import shaded.org.eclipse.aether.impl.MetadataGenerator;
import shaded.org.eclipse.aether.impl.MetadataGeneratorFactory;
import shaded.org.eclipse.aether.impl.OfflineController;
import shaded.org.eclipse.aether.internal.impl.PrioritizedComponents;
import shaded.org.eclipse.aether.metadata.Metadata;
import shaded.org.eclipse.aether.repository.RemoteRepository;
import shaded.org.eclipse.aether.resolution.ResolutionErrorPolicy;
import shaded.org.eclipse.aether.resolution.ResolutionErrorPolicyRequest;
import shaded.org.eclipse.aether.transfer.RepositoryOfflineException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Utils {
    Utils() {
    }

    public static PrioritizedComponents<MetadataGeneratorFactory> sortMetadataGeneratorFactories(RepositorySystemSession session, Collection<? extends MetadataGeneratorFactory> factories) {
        PrioritizedComponents<MetadataGeneratorFactory> result = new PrioritizedComponents<MetadataGeneratorFactory>(session);
        for (MetadataGeneratorFactory metadataGeneratorFactory : factories) {
            result.add(metadataGeneratorFactory, metadataGeneratorFactory.getPriority());
        }
        return result;
    }

    public static List<Metadata> prepareMetadata(List<? extends MetadataGenerator> generators, List<? extends Artifact> artifacts) {
        ArrayList<Metadata> metadatas = new ArrayList<Metadata>();
        for (MetadataGenerator metadataGenerator : generators) {
            metadatas.addAll(metadataGenerator.prepare(artifacts));
        }
        return metadatas;
    }

    public static List<Metadata> finishMetadata(List<? extends MetadataGenerator> generators, List<? extends Artifact> artifacts) {
        ArrayList<Metadata> metadatas = new ArrayList<Metadata>();
        for (MetadataGenerator metadataGenerator : generators) {
            metadatas.addAll(metadataGenerator.finish(artifacts));
        }
        return metadatas;
    }

    public static <T> List<T> combine(Collection<? extends T> first, Collection<? extends T> second) {
        ArrayList<T> result = new ArrayList<T>(first.size() + second.size());
        result.addAll(first);
        result.addAll(second);
        return result;
    }

    public static int getPolicy(RepositorySystemSession session, Artifact artifact, RemoteRepository repository) {
        ResolutionErrorPolicy rep = session.getResolutionErrorPolicy();
        if (rep == null) {
            return 0;
        }
        return rep.getArtifactPolicy(session, new ResolutionErrorPolicyRequest<Artifact>(artifact, repository));
    }

    public static int getPolicy(RepositorySystemSession session, Metadata metadata, RemoteRepository repository) {
        ResolutionErrorPolicy rep = session.getResolutionErrorPolicy();
        if (rep == null) {
            return 0;
        }
        return rep.getMetadataPolicy(session, new ResolutionErrorPolicyRequest<Metadata>(metadata, repository));
    }

    public static void appendClassLoader(StringBuilder buffer, Object component) {
        ClassLoader loader = component.getClass().getClassLoader();
        if (loader != null && !loader.equals(Utils.class.getClassLoader())) {
            buffer.append(" from ").append(loader);
        }
    }

    public static void checkOffline(RepositorySystemSession session, OfflineController offlineController, RemoteRepository repository) throws RepositoryOfflineException {
        if (session.isOffline()) {
            offlineController.checkOffline(session, repository);
        }
    }
}

