/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.kex;

import java.math.BigInteger;
import java.security.PublicKey;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.Digest;
import org.apache.sshd.common.KeyExchange;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Signature;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.kex.AbstractDH;
import org.apache.sshd.common.kex.DH;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.KeyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHGEX
implements KeyExchange {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ClientSessionImpl session;
    private byte[] V_S;
    private byte[] V_C;
    private byte[] I_S;
    private byte[] I_C;
    private Digest hash;
    private AbstractDH dh;
    private byte[] p;
    private byte[] g;
    private byte[] e;
    private byte[] f;
    private byte[] K;
    private byte[] H;
    private PublicKey serverKey;
    private byte expected;
    int min = 1024;
    int prf = 4096;
    int max = 8192;

    public void init(AbstractSession s, byte[] V_S, byte[] V_C, byte[] I_S, byte[] I_C) throws Exception {
        if (!(s instanceof ClientSessionImpl)) {
            throw new IllegalStateException("Using a client side KeyExchange on a server");
        }
        this.session = (ClientSessionImpl)s;
        this.V_S = V_S;
        this.V_C = V_C;
        this.I_S = I_S;
        this.I_C = I_C;
        this.log.debug("Send SSH_MSG_KEX_DH_GEX_REQUEST");
        Buffer buffer = this.session.createBuffer((byte)34);
        buffer.putInt(this.min);
        buffer.putInt(this.prf);
        buffer.putInt(this.max);
        this.session.writePacket(buffer);
        this.expected = (byte)31;
    }

    public boolean next(Buffer buffer) throws Exception {
        byte cmd = buffer.getByte();
        if (cmd != this.expected) {
            throw new SshException(3, "Protocol error: expected packet " + this.expected + ", got " + cmd);
        }
        if (cmd == 31) {
            this.log.debug("Received SSH_MSG_KEX_DH_GEX_GROUP");
            this.p = buffer.getMPIntAsBytes();
            this.g = buffer.getMPIntAsBytes();
            this.dh = this.getDH(new BigInteger(this.p), new BigInteger(this.g));
            this.hash = this.dh.getHash();
            this.hash.init();
            this.e = this.dh.getE();
            this.log.debug("Send SSH_MSG_KEX_DH_GEX_INIT");
            buffer = this.session.createBuffer((byte)32);
            buffer.putMPInt(this.e);
            this.session.writePacket(buffer);
            this.expected = (byte)33;
            return false;
        }
        if (cmd == 33) {
            this.log.debug("Received SSH_MSG_KEX_DH_GEX_REPLY");
            byte[] K_S = buffer.getBytes();
            this.f = buffer.getMPIntAsBytes();
            byte[] sig = buffer.getBytes();
            this.dh.setF(this.f);
            this.K = this.dh.getK();
            buffer = new Buffer(K_S);
            this.serverKey = buffer.getRawPublicKey();
            String keyAlg = KeyUtils.getKeyType(this.serverKey);
            if (keyAlg == null) {
                throw new SshException("Unsupported server key type");
            }
            buffer = new Buffer();
            buffer.putString(this.V_C);
            buffer.putString(this.V_S);
            buffer.putString(this.I_C);
            buffer.putString(this.I_S);
            buffer.putString(K_S);
            buffer.putInt(this.min);
            buffer.putInt(this.prf);
            buffer.putInt(this.max);
            buffer.putMPInt(this.p);
            buffer.putMPInt(this.g);
            buffer.putMPInt(this.e);
            buffer.putMPInt(this.f);
            buffer.putMPInt(this.K);
            this.hash.update(buffer.array(), 0, buffer.available());
            this.H = this.hash.digest();
            Signature verif = (Signature)NamedFactory.Utils.create(this.session.getFactoryManager().getSignatureFactories(), keyAlg);
            verif.init(this.serverKey, null);
            verif.update(this.H, 0, this.H.length);
            if (!verif.verify(sig)) {
                throw new SshException(3, "KeyExchange signature verification failed");
            }
            return true;
        }
        throw new IllegalStateException();
    }

    protected DH getDH(BigInteger p, BigInteger g) throws Exception {
        DH dh = new DH();
        dh.setP(p);
        dh.setG(g);
        return dh;
    }

    public Digest getHash() {
        return this.hash;
    }

    public byte[] getH() {
        return this.H;
    }

    public byte[] getK() {
        return this.K;
    }

    public PublicKey getServerKey() {
        return this.serverKey;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements NamedFactory<KeyExchange> {
        @Override
        public String getName() {
            return "diffie-hellman-group-exchange-sha1";
        }

        @Override
        public KeyExchange create() {
            return new DHGEX();
        }
    }
}

