/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.EOFException;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelHolder;
import org.apache.sshd.common.channel.IoWriteFutureImpl;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.io.PacketWriter;
import org.apache.sshd.common.io.WritePendingException;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;

public class ChannelAsyncOutputStream
extends AbstractCloseable
implements IoOutputStream,
ChannelHolder {
    private final Channel channelInstance;
    private final PacketWriter packetWriter;
    private final byte cmd;
    private final AtomicReference<IoWriteFutureImpl> pendingWrite = new AtomicReference();
    private final Object packetWriteId;

    public ChannelAsyncOutputStream(Channel channel, byte cmd) {
        this.channelInstance = Objects.requireNonNull(channel, "No channel");
        this.packetWriter = this.channelInstance.resolveChannelStreamPacketWriter(channel, cmd);
        this.cmd = cmd;
        this.packetWriteId = channel.toString() + "[" + SshConstants.getCommandMessageName(cmd) + "]";
    }

    @Override
    public Channel getChannel() {
        return this.channelInstance;
    }

    public void onWindowExpanded() throws IOException {
        this.doWriteIfPossible(true);
    }

    @Override
    public synchronized IoWriteFuture writePacket(Buffer buffer) throws IOException {
        if (this.isClosing()) {
            throw new EOFException("Closed");
        }
        IoWriteFutureImpl future = new IoWriteFutureImpl(this.packetWriteId, buffer);
        if (!this.pendingWrite.compareAndSet(null, future)) {
            throw new WritePendingException("No write pending future");
        }
        this.doWriteIfPossible(false);
        return future;
    }

    @Override
    protected void preClose() {
        if (!(this.packetWriter instanceof Channel)) {
            try {
                this.packetWriter.close();
            }
            catch (IOException e) {
                this.log.error("preClose({}) Failed ({}) to pre-close packet writer: {}", new Object[]{this, e.getClass().getSimpleName(), e.getMessage()});
            }
        }
        super.preClose();
    }

    @Override
    protected CloseFuture doCloseGracefully() {
        return this.builder().when((SshFuture)this.pendingWrite.get()).build().close(false);
    }

    protected synchronized void doWriteIfPossible(boolean resume) {
        final IoWriteFutureImpl future = this.pendingWrite.get();
        if (future == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("doWriteIfPossible({})[resume={}] no pending write future", (Object)this, (Object)resume);
            }
            return;
        }
        Buffer buffer = future.getBuffer();
        final int total = buffer.available();
        if (total > 0) {
            Channel channel = this.getChannel();
            Window remoteWindow = channel.getRemoteWindow();
            final long length = Math.min(Math.min(remoteWindow.getSize(), (long)total), remoteWindow.getPacketSize());
            if (this.log.isTraceEnabled()) {
                this.log.trace("doWriteIfPossible({})[resume={}] attempting to write {} out of {}", new Object[]{this, resume, length, total});
            }
            if (length > 0L) {
                if (resume && this.log.isDebugEnabled()) {
                    this.log.debug("Resuming {} write due to more space ({}) available in the remote window", (Object)this, (Object)length);
                }
                if (length >= 0x7FFFFFF3L) {
                    throw new IllegalArgumentException("Command " + SshConstants.getCommandMessageName(this.cmd) + " length (" + length + ") exceeds int boundaries");
                }
                Session s = channel.getSession();
                Buffer buf = s.createBuffer(this.cmd, (int)length + 12);
                buf.putInt(channel.getRecipient());
                if (this.cmd == 95) {
                    buf.putInt(1L);
                }
                buf.putInt(length);
                buf.putRawBytes(buffer.array(), buffer.rpos(), (int)length);
                buffer.rpos(buffer.rpos() + (int)length);
                remoteWindow.consume(length);
                try {
                    final ChannelAsyncOutputStream stream = this;
                    IoWriteFuture writeFuture = this.packetWriter.writePacket(buf);
                    writeFuture.addListener(new SshFutureListener<IoWriteFuture>(){

                        @Override
                        public void operationComplete(IoWriteFuture f) {
                            if (f.isWritten()) {
                                this.handleOperationCompleted();
                            } else {
                                this.handleOperationFailed(f.getException());
                            }
                        }

                        private void handleOperationCompleted() {
                            if ((long)total > length) {
                                if (ChannelAsyncOutputStream.this.log.isTraceEnabled()) {
                                    ChannelAsyncOutputStream.this.log.trace("doWriteIfPossible({}) completed write of {} out of {}", new Object[]{stream, length, total});
                                }
                                ChannelAsyncOutputStream.this.doWriteIfPossible(false);
                            } else {
                                boolean nullified = ChannelAsyncOutputStream.this.pendingWrite.compareAndSet(future, null);
                                if (ChannelAsyncOutputStream.this.log.isTraceEnabled()) {
                                    ChannelAsyncOutputStream.this.log.trace("doWriteIfPossible({}) completed write len={}, more={}", new Object[]{stream, total, !nullified});
                                }
                                future.setValue(Boolean.TRUE);
                            }
                        }

                        private void handleOperationFailed(Throwable reason) {
                            if (ChannelAsyncOutputStream.this.log.isDebugEnabled()) {
                                ChannelAsyncOutputStream.this.log.debug("doWriteIfPossible({}) failed ({}) to complete write of {} out of {}: {}", new Object[]{stream, reason.getClass().getSimpleName(), length, total, reason.getMessage()});
                            }
                            if (ChannelAsyncOutputStream.this.log.isTraceEnabled()) {
                                ChannelAsyncOutputStream.this.log.trace("doWriteIfPossible(" + this + ") write failure details", reason);
                            }
                            boolean nullified = ChannelAsyncOutputStream.this.pendingWrite.compareAndSet(future, null);
                            if (ChannelAsyncOutputStream.this.log.isTraceEnabled()) {
                                ChannelAsyncOutputStream.this.log.trace("doWriteIfPossible({}) failed write len={}, more={}", new Object[]{stream, total, !nullified});
                            }
                            future.setValue(reason);
                        }
                    });
                }
                catch (IOException e) {
                    future.setValue(e);
                }
            } else if (!resume && this.log.isDebugEnabled()) {
                this.log.debug("doWriteIfPossible({}) delaying write until space is available in the remote window", (Object)this);
            }
        } else {
            boolean nullified = this.pendingWrite.compareAndSet(future, null);
            if (this.log.isTraceEnabled()) {
                this.log.trace("doWriteIfPossible({}) current buffer sent - more={}", (Object)this, (Object)(!nullified ? 1 : 0));
            }
            future.setValue(Boolean.TRUE);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getChannel() + "] cmd=" + SshConstants.getCommandMessageName(this.cmd & 0xFF);
    }
}

