/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.audit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.apache.karaf.jaas.modules.audit.AbstractAuditLoginModule;

public class FileAuditLoginModule
extends AbstractAuditLoginModule {
    public static final String LOG_FILE_OPTION = "file";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private String logFile;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.logFile = (String)options.get(LOG_FILE_OPTION);
    }

    @Override
    protected synchronized void audit(AbstractAuditLoginModule.Action action, String username) {
        Date date = new Date();
        try {
            String actionStr;
            File file = new File(this.logFile);
            file.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(file, true);
            FileChannel channel = out.getChannel();
            FileLock lock = channel.lock(0L, Long.MAX_VALUE, false);
            PrintWriter writer = new PrintWriter(out, false);
            switch (action) {
                case ATTEMPT: {
                    actionStr = "Authentication attempt";
                    break;
                }
                case SUCCESS: {
                    actionStr = "Authentication succeeded";
                    break;
                }
                case FAILURE: {
                    actionStr = "Authentication failed";
                    break;
                }
                case LOGOUT: {
                    actionStr = "Explicit logout";
                    break;
                }
                default: {
                    actionStr = action.toString();
                }
            }
            writer.println(DATE_FORMAT.format(date) + " - " + actionStr + " - " + username);
            writer.flush();
            writer.close();
            if (lock.isValid()) {
                lock.release();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write to authentication log file", e);
        }
    }
}

