/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.metatype.internal.l10n;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.felix.metatype.internal.l10n.Resources;
import org.osgi.framework.Bundle;

public class BundleResources {
    private Bundle bundle;
    private long bundleLastModified;
    private Map resourcesByLocale;
    private static Map resourcesByBundle = null;

    public static Resources getResources(Bundle bundle, String basename, String locale) {
        BundleResources bundleResources = null;
        if (resourcesByBundle != null) {
            if (bundle.getState() == 1) {
                resourcesByBundle.remove(new Long(bundle.getBundleId()));
                return null;
            }
            bundleResources = (BundleResources)resourcesByBundle.get(new Long(bundle.getBundleId()));
        } else {
            resourcesByBundle = new HashMap();
        }
        if (bundleResources == null) {
            bundleResources = new BundleResources(bundle);
            resourcesByBundle.put(new Long(bundle.getBundleId()), bundleResources);
        }
        return super.getResources(basename, locale);
    }

    public static void clearResourcesCache() {
        resourcesByBundle = null;
    }

    private BundleResources(Bundle bundle) {
        this.bundle = bundle;
        this.bundleLastModified = bundle.getLastModified();
        this.resourcesByLocale = new HashMap();
    }

    private boolean isUpToDate() {
        return this.bundle.getState() != 1 && this.bundleLastModified >= this.bundle.getLastModified();
    }

    private Resources getResources(String basename, String locale) {
        if (locale == null) {
            locale = Locale.getDefault().toString();
        }
        String key = basename + "-" + locale;
        if (this.isUpToDate()) {
            Resources res = (Resources)this.resourcesByLocale.get(key);
            if (res != null) {
                return res;
            }
        } else {
            this.resourcesByLocale.clear();
        }
        Properties parentProperties = null;
        List resList = this.createResourceList(locale);
        for (String tmpLocale : resList) {
            String tmpKey = basename + "-" + tmpLocale;
            Resources res = (Resources)this.resourcesByLocale.get(tmpKey);
            if (res != null) {
                parentProperties = res.getResources();
                continue;
            }
            Properties props = this.loadProperties(basename, tmpLocale, parentProperties);
            res = new Resources(tmpLocale, props);
            this.resourcesByLocale.put(tmpKey, res);
            parentProperties = props;
        }
        return (Resources)this.resourcesByLocale.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(String basename, String locale, Properties parentProperties) {
        String resourceName = basename;
        if (locale != null && locale.length() > 0) {
            resourceName = resourceName + "_" + locale;
        }
        resourceName = resourceName + ".properties";
        Properties props = new Properties(parentProperties);
        URL resURL = this.bundle.getResource(resourceName);
        if (resURL == null) {
            resURL = this.bundle.getResource("OSGI-INF/metatype/" + resourceName);
        }
        if (resURL != null) {
            InputStream ins = null;
            try {
                ins = resURL.openStream();
                props.load(ins);
            }
            catch (IOException iOException) {
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return props;
    }

    private List createResourceList(String locale) {
        ArrayList<String> result = new ArrayList<String>(4);
        StringBuffer tempLocale = new StringBuffer();
        result.add(tempLocale.toString());
        if (locale != null && locale.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(locale, "_");
            while (tokens.hasMoreTokens()) {
                if (tempLocale.length() > 0) {
                    tempLocale.append("_");
                }
                tempLocale.append(tokens.nextToken());
                result.add(tempLocale.toString());
            }
        }
        return result;
    }
}

