/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.PrintWriter;
import org.apache.felix.scr.impl.ScrCommand;
import org.apache.felix.service.command.Descriptor;

class ScrGogoCommand {
    private final ScrCommand scrCommand;

    public ScrGogoCommand(ScrCommand scrCommand) {
        this.scrCommand = scrCommand;
    }

    @Descriptor(value="List all component configurations")
    public void list() {
        try {
            this.scrCommand.list(null, new PrintWriter(System.out));
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
        }
    }

    @Descriptor(value="List component configurations of a specific bundle")
    public void list(@Descriptor(value="Symbolic name or ID of the bundle") String bundleIdentifier) {
        try {
            this.scrCommand.list(bundleIdentifier, new PrintWriter(System.out));
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
        }
    }

    @Descriptor(value="Dump information of a component or component configuration")
    public void info(@Descriptor(value="Name of the component or ID of the component configuration") String componentIdentifier) {
        try {
            this.scrCommand.info(componentIdentifier, new PrintWriter(System.out));
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
        }
    }

    @Descriptor(value="Enable a disabled component")
    public void enable(@Descriptor(value="Name of the component") String componentIdentifier) {
        try {
            this.scrCommand.change(componentIdentifier, new PrintWriter(System.out), true);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
        }
    }

    @Descriptor(value="Disable an enabled component")
    public void disable(@Descriptor(value="Name of the component") String componentIdentifier) {
        try {
            this.scrCommand.change(componentIdentifier, new PrintWriter(System.out), false);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
        }
    }

    @Descriptor(value="Show the current SCR configuration")
    public void config() {
        this.scrCommand.config(new PrintWriter(System.out));
    }
}

