/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;

@FunctionalInterface
public interface PublicKeyEntryResolver {
    public static final PublicKeyEntryResolver IGNORING = new PublicKeyEntryResolver(){

        @Override
        public PublicKey resolve(String keyType, byte[] keyData) throws IOException, GeneralSecurityException {
            return null;
        }

        public String toString() {
            return "IGNORING";
        }
    };
    public static final PublicKeyEntryResolver FAILING = new PublicKeyEntryResolver(){

        @Override
        public PublicKey resolve(String keyType, byte[] keyData) throws IOException, GeneralSecurityException {
            throw new InvalidKeySpecException("Failing resolver on key type=" + keyType);
        }

        public String toString() {
            return "FAILING";
        }
    };

    public PublicKey resolve(String var1, byte[] var2) throws IOException, GeneralSecurityException;
}

