/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import java.util.Set;
import org.apache.sshd.client.subsystem.sftp.SftpFileSystem;
import org.apache.sshd.client.subsystem.sftp.SftpFileSystemProvider;
import org.apache.sshd.common.util.GenericUtils;

public class SftpFileStore
extends FileStore {
    private final SftpFileSystem fs;
    private final String name;

    public SftpFileStore(String name, SftpFileSystem fs) {
        this.name = name;
        this.fs = fs;
    }

    public final SftpFileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return "sftp";
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public long getTotalSpace() throws IOException {
        return Long.MAX_VALUE;
    }

    @Override
    public long getUsableSpace() throws IOException {
        return Long.MAX_VALUE;
    }

    @Override
    public long getUnallocatedSpace() throws IOException {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        SftpFileSystem sftpFs = this.getFileSystem();
        SftpFileSystemProvider provider = sftpFs.provider();
        return provider.isSupportedFileAttributeView(sftpFs, type);
    }

    @Override
    public boolean supportsFileAttributeView(String name) {
        if (GenericUtils.isEmpty(name)) {
            return false;
        }
        SftpFileSystem sftpFs = this.getFileSystem();
        Set<String> views = ((FileSystem)sftpFs).supportedFileAttributeViews();
        return !GenericUtils.isEmpty(views) && views.contains(name);
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
        return null;
    }

    @Override
    public Object getAttribute(String attribute) throws IOException {
        return null;
    }
}

