/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal.parser;

import java.util.List;
import javax.servlet.MultipartConfigElement;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.http.HttpServlet;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.model.WebAppInitParam;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServlet;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServletMapping;
import org.ops4j.pax.web.extender.war.internal.parser.AnnotationConfigurer;
import org.ops4j.pax.web.utils.ServletAnnotationScanner;
import org.osgi.framework.Bundle;

public class WebServletAnnotationConfigurer
extends AnnotationConfigurer<WebServletAnnotationConfigurer> {
    public WebServletAnnotationConfigurer(Bundle bundle, String clazz) {
        super(bundle, clazz);
    }

    public void scan(WebApp webApp) {
        Class<?> clazz = this.loadClass();
        if (clazz == null) {
            this.log.warn("Class {} wasn't loaded", (Object)this.className);
            return;
        }
        if (!HttpServlet.class.isAssignableFrom(clazz)) {
            this.log.warn(clazz.getName() + " is not assignable from javax.servlet.http.HttpServlet");
            return;
        }
        ServletAnnotationScanner annotationParameter = new ServletAnnotationScanner(clazz);
        WebAppServlet webAppServlet = webApp.findServlet(annotationParameter.servletName);
        this.log.debug("Registering Servlet {} with url(s) {}", (Object)annotationParameter.servletName, (Object)annotationParameter.urlPatterns);
        if (webAppServlet == null) {
            this.log.debug("Create a new Servlet");
            webAppServlet = new WebAppServlet();
            webAppServlet.setServletName(annotationParameter.servletName);
            webAppServlet.setServletClassName(this.className);
            webApp.addServlet(webAppServlet);
            webAppServlet.setLoadOnStartup(annotationParameter.loadOnStartup);
            webAppServlet.setAsyncSupported(annotationParameter.asyncSupported);
        } else {
            annotationParameter.servletName = webAppServlet.getServletName();
        }
        WebAppInitParam[] initParams = webAppServlet.getInitParams();
        for (WebInitParam ip : annotationParameter.webInitParams) {
            if (this.initParamsContain(initParams, ip.name())) continue;
            WebAppInitParam initParam = new WebAppInitParam();
            initParam.setParamName(ip.name());
            initParam.setParamValue(ip.value());
            webAppServlet.addInitParam(initParam);
        }
        List<WebAppServletMapping> mappings = webApp.getServletMappings(annotationParameter.servletName);
        this.log.debug("Found the following mappings {} for servlet: {}", mappings, (Object)annotationParameter.servletName);
        if (mappings == null || mappings.isEmpty()) {
            this.log.debug("alter/create mappings");
            for (String urlPattern : annotationParameter.urlPatterns) {
                this.log.debug("adding mapping for URL {}", (Object)urlPattern);
                WebAppServletMapping mapping = new WebAppServletMapping();
                mapping.setServletName(annotationParameter.servletName);
                mapping.setUrlPattern(urlPattern);
                webApp.addServletMapping(mapping);
            }
        }
        if (null != annotationParameter.multiPartConfigAnnotation) {
            MultipartConfigElement multipartConfig = new MultipartConfigElement(annotationParameter.multiPartConfigAnnotation);
            webAppServlet.setMultipartConfig(multipartConfig);
        }
    }
}

