/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.util.Hashtable;
import org.ops4j.pax.web.extender.war.internal.DefaultWebAppDependencyManager;
import org.ops4j.pax.web.extender.war.internal.WebAppPublisher;
import org.ops4j.pax.web.extender.war.internal.WebEventDispatcher;
import org.ops4j.pax.web.extender.war.internal.WebObserver;
import org.ops4j.pax.web.extender.war.internal.extender.AbstractExtender;
import org.ops4j.pax.web.extender.war.internal.extender.Extension;
import org.ops4j.pax.web.extender.war.internal.parser.WebAppParser;
import org.ops4j.pax.web.service.spi.WarManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends AbstractExtender {
    private ServiceTracker<PackageAdmin, PackageAdmin> packageAdminTracker;
    private WebObserver webObserver;
    private WebEventDispatcher webEventDispatcher;
    private ServiceRegistration<WarManager> registration;

    @Override
    protected void doStart() throws Exception {
        this.logger.debug("Pax Web WAR Extender - Starting");
        BundleContext bundleContext = this.getBundleContext();
        this.webEventDispatcher = new WebEventDispatcher(bundleContext);
        Filter filterPackage = bundleContext.createFilter("(objectClass=org.osgi.service.packageadmin.PackageAdmin)");
        this.packageAdminTracker = new ServiceTracker(bundleContext, filterPackage, null);
        this.packageAdminTracker.open();
        DefaultWebAppDependencyManager dependencyManager = new DefaultWebAppDependencyManager();
        this.webObserver = new WebObserver(new WebAppParser(this.packageAdminTracker), new WebAppPublisher(this.webEventDispatcher, bundleContext), this.webEventDispatcher, dependencyManager, bundleContext);
        this.startTracking();
        this.registration = this.getBundleContext().registerService(WarManager.class, (Object)this.webObserver, new Hashtable());
        this.logger.debug("Pax Web WAR Extender - Started");
    }

    @Override
    protected void doStop() throws Exception {
        this.logger.debug("Pax Web WAR Extender - Stopping");
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        this.stopTracking();
        this.webEventDispatcher.destroy();
        this.packageAdminTracker.close();
        this.logger.debug("Pax Web WAR Extender - Stopped");
    }

    @Override
    protected Extension doCreateExtension(Bundle bundle) throws Exception {
        return this.webObserver.createExtension(bundle);
    }
}

