/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class TimeoutCompleteListener
implements Response.CompleteListener,
Runnable {
    private static final Logger LOG = Log.getLogger(TimeoutCompleteListener.class);
    private final AtomicReference<Scheduler.Task> task = new AtomicReference();
    private final Request request;

    public TimeoutCompleteListener(Request request) {
        this.request = request;
    }

    @Override
    public void onComplete(Result result) {
        this.cancel();
    }

    public boolean schedule(Scheduler scheduler) {
        long timeout = this.request.getTimeout();
        Scheduler.Task task = scheduler.schedule((Runnable)this, timeout, TimeUnit.MILLISECONDS);
        Scheduler.Task existing = this.task.getAndSet(task);
        if (existing != null) {
            existing.cancel();
            this.cancel();
            throw new IllegalStateException();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduled timeout task {} in {} ms for {}", new Object[]{task, timeout, this.request});
        }
        return true;
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing timeout task {} for {}", new Object[]{this.task, this.request});
        }
        this.request.abort(new TimeoutException("Total timeout " + this.request.getTimeout() + " ms elapsed"));
    }

    public void cancel() {
        Scheduler.Task task = this.task.getAndSet(null);
        if (task != null) {
            boolean cancelled = task.cancel();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cancelled (successfully: {}) timeout task {}", new Object[]{cancelled, task});
            }
        }
    }
}

