/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util;

import org.apache.aries.util.internal.DefaultWorker;
import org.apache.aries.util.internal.EquinoxWorker;
import org.apache.aries.util.internal.FelixWorker;
import org.apache.aries.util.internal.FrameworkUtilWorker;
import org.apache.aries.util.internal.R43Worker;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public final class AriesFrameworkUtil {
    private static FrameworkUtilWorker worker;

    public static ClassLoader getClassLoader(Bundle b) {
        if (b != null && b.getState() != 1 && b.getState() != 2) {
            return worker.getClassLoader(b);
        }
        return null;
    }

    private static boolean isEquinox(String bundleClassName) {
        if (bundleClassName.startsWith("org.eclipse.osgi")) {
            try {
                Class.forName("org.eclipse.osgi.framework.internal.core.BundleHost");
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    public static ClassLoader getClassLoaderForced(Bundle b) {
        if (b == null) {
            return null;
        }
        try {
            b.loadClass("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return worker.getClassLoader(b);
    }

    public static void safeUnregisterService(ServiceRegistration reg) {
        if (reg != null) {
            try {
                reg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    static {
        String bundleClassName;
        try {
            worker = new R43Worker();
        }
        catch (Throwable e) {
            // empty catch block
        }
        Bundle b = FrameworkUtil.getBundle(AriesFrameworkUtil.class);
        String string = bundleClassName = b == null ? "" : b.getClass().getName();
        if (worker == null && AriesFrameworkUtil.isEquinox(bundleClassName)) {
            worker = new EquinoxWorker();
        } else if (worker == null && bundleClassName.startsWith("org.apache.felix")) {
            worker = new FelixWorker();
        }
        if (worker == null || !worker.isValid()) {
            worker = new DefaultWorker();
        }
    }
}

