/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.compression;

import com.jcraft.jzlib.ZStream;
import java.io.IOException;
import org.apache.sshd.common.Compression;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.Buffer;

public class CompressionZlib
implements Compression {
    private static final int BUF_SIZE = 4096;
    private ZStream stream;
    private byte[] tmpbuf = new byte[4096];

    public boolean isDelayed() {
        return false;
    }

    public void init(Compression.Type type, int level) {
        this.stream = new ZStream();
        if (type == Compression.Type.Deflater) {
            this.stream.deflateInit(level);
        } else {
            this.stream.inflateInit();
        }
    }

    public void compress(Buffer buffer) throws IOException {
        this.stream.next_in = buffer.array();
        this.stream.next_in_index = buffer.rpos();
        this.stream.avail_in = buffer.available();
        buffer.wpos(buffer.rpos());
        do {
            this.stream.next_out = this.tmpbuf;
            this.stream.next_out_index = 0;
            this.stream.avail_out = 4096;
            int status = this.stream.deflate(1);
            switch (status) {
                case 0: {
                    buffer.putRawBytes(this.tmpbuf, 0, 4096 - this.stream.avail_out);
                    break;
                }
                default: {
                    throw new SshException(6, "compress: deflate returned " + status);
                }
            }
        } while (this.stream.avail_out == 0);
    }

    public void uncompress(Buffer from, Buffer to) throws IOException {
        int status;
        this.stream.next_in = from.array();
        this.stream.next_in_index = from.rpos();
        this.stream.avail_in = from.available();
        block4: while (true) {
            this.stream.next_out = this.tmpbuf;
            this.stream.next_out_index = 0;
            this.stream.avail_out = 4096;
            status = this.stream.inflate(1);
            switch (status) {
                case 0: {
                    to.putRawBytes(this.tmpbuf, 0, 4096 - this.stream.avail_out);
                    continue block4;
                }
                case -5: {
                    return;
                }
            }
            break;
        }
        throw new SshException(6, "uncompress: inflate returned " + status);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements NamedFactory<Compression> {
        @Override
        public String getName() {
            return "zlib";
        }

        @Override
        public Compression create() {
            return new CompressionZlib();
        }
    }
}

