/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.CircularDependencyException;
import aQute.bnd.build.Container;
import aQute.bnd.build.DownloadBlocker;
import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.build.ProjectLauncher;
import aQute.bnd.build.ProjectMessages;
import aQute.bnd.build.ProjectTester;
import aQute.bnd.build.ReflectAction;
import aQute.bnd.build.ScriptAction;
import aQute.bnd.build.Workspace;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.help.Syntax;
import aQute.bnd.maven.support.Pom;
import aQute.bnd.maven.support.ProjectPom;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Macro;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.osgi.eclipse.EclipseClasspath;
import aQute.bnd.service.CommandPlugin;
import aQute.bnd.service.DependencyContributor;
import aQute.bnd.service.Deploy;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.Scripter;
import aQute.bnd.service.Strategy;
import aQute.bnd.service.action.Action;
import aQute.bnd.service.action.NamedAction;
import aQute.bnd.version.Version;
import aQute.bnd.version.VersionRange;
import aQute.lib.io.IO;
import aQute.libg.generics.Create;
import aQute.libg.reporter.ReporterMessages;
import aQute.libg.sed.Replacer;
import aQute.libg.sed.Sed;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
extends Processor {
    static final Pattern VERSION_ANNOTATION = Pattern.compile("@\\s*(:?aQute\\.bnd\\.annotation\\.)?Version\\s*\\(\\s*(:?value\\s*=\\s*)?\"(\\d+(:?\\.\\d+(:?\\.\\d+(:?\\.[\\d\\w-_]+)?)?)?)\"\\s*\\)");
    static final String DEFAULT_ACTIONS = "build; label='Build', test; label='Test', run; label='Run', clean; label='Clean', release; label='Release', refreshAll; label=Refresh, deploy;label=Deploy";
    public static final String BNDFILE = "bnd.bnd";
    public static final String BNDCNF = "cnf";
    final Workspace workspace;
    boolean preparedPaths;
    final Collection<Project> dependson = new LinkedHashSet<Project>();
    final Collection<Container> classpath = new LinkedHashSet<Container>();
    final Collection<Container> buildpath = new LinkedHashSet<Container>();
    final Collection<Container> testpath = new LinkedHashSet<Container>();
    final Collection<Container> runpath = new LinkedHashSet<Container>();
    final Collection<Container> runbundles = new LinkedHashSet<Container>();
    File runstorage;
    final Collection<File> sourcepath = new LinkedHashSet<File>();
    final Collection<File> allsourcepath = new LinkedHashSet<File>();
    final Collection<Container> bootclasspath = new LinkedHashSet<Container>();
    final Lock lock = new ReentrantLock(true);
    volatile String lockingReason;
    volatile Thread lockingThread;
    File output;
    File target;
    boolean inPrepare;
    int revision;
    File[] files;
    static List<Project> trail = new ArrayList<Project>();
    boolean delayRunDependencies = false;
    final ProjectMessages msgs = ReporterMessages.base(this, ProjectMessages.class);
    static String _repoHelp = "${repo ';'<bsn> [ ; <version> [; ('HIGHEST'|'LOWEST')]}";

    public Project(Workspace workspace, File projectDir, File buildFile) throws Exception {
        super(workspace);
        this.workspace = workspace;
        this.setFileMustExist(false);
        this.setProperties(buildFile);
        assert (workspace != null);
        this.readBuildProperties();
    }

    public Project(Workspace workspace, File buildDir) throws Exception {
        this(workspace, buildDir, new File(buildDir, BNDFILE));
    }

    private void readBuildProperties() throws Exception {
        try {
            File f = this.getFile("build.properties");
            if (f.isFile()) {
                Properties p = this.loadProperties(f);
                Enumeration<?> e = p.propertyNames();
                while (e.hasMoreElements()) {
                    String key;
                    String newkey = key = (String)e.nextElement();
                    if (key.indexOf(36) >= 0) {
                        newkey = this.getReplacer().process(key);
                    }
                    this.setProperty(newkey, p.getProperty(key));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Project getUnparented(File propertiesFile) throws Exception {
        propertiesFile = propertiesFile.getAbsoluteFile();
        Workspace workspace = new Workspace(propertiesFile.getParentFile());
        Project project = new Project(workspace, propertiesFile.getParentFile());
        project.setProperties(propertiesFile);
        project.setFileMustExist(true);
        return project;
    }

    public synchronized boolean isValid() {
        return this.getBase().isDirectory() && this.getPropertiesFile().isFile();
    }

    public synchronized ProjectBuilder getBuilder(ProjectBuilder parent) throws Exception {
        ProjectBuilder builder = parent == null ? new ProjectBuilder(this) : new ProjectBuilder(parent);
        builder.setBase(this.getBase());
        builder.setPedantic(this.isPedantic());
        builder.setTrace(this.isTrace());
        return builder;
    }

    public synchronized int getChanged() {
        return this.revision;
    }

    public synchronized void setChanged() {
        this.preparedPaths = false;
        this.files = null;
        ++this.revision;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public String toString() {
        return this.getBase().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void prepare() throws Exception {
        block22: {
            if (!this.isValid()) {
                this.warning("Invalid project attempts to prepare: %s", this);
                return;
            }
            if (this.inPrepare) {
                throw new CircularDependencyException(trail.toString() + "," + this);
            }
            trail.add(this);
            try {
                if (this.preparedPaths) break block22;
                this.inPrepare = true;
                try {
                    File src;
                    this.dependson.clear();
                    this.buildpath.clear();
                    this.sourcepath.clear();
                    this.allsourcepath.clear();
                    this.bootclasspath.clear();
                    this.testpath.clear();
                    this.runpath.clear();
                    this.runbundles.clear();
                    this.setProperty("basedir", this.getBase().getAbsolutePath());
                    if (!this.getPropertiesFile().isFile() && new File(this.getBase(), ".classpath").isFile()) {
                        this.doEclipseClasspath();
                    }
                    if ((src = this.getSrc()).isDirectory()) {
                        this.sourcepath.add(src);
                        this.allsourcepath.add(src);
                    } else {
                        this.sourcepath.add(this.getBase());
                    }
                    this.output = this.getOutput0();
                    if (!this.output.exists()) {
                        if (!this.output.mkdirs()) {
                            throw new IOException("Could not create directory " + this.output);
                        }
                        this.getWorkspace().changedFile(this.output);
                    }
                    if (!this.output.isDirectory()) {
                        this.msgs.NoOutputDirectory_(this.output);
                    } else {
                        Container c = new Container(this, this.output);
                        if (!this.buildpath.contains(c)) {
                            this.buildpath.add(c);
                        }
                    }
                    this.target = this.getTarget0();
                    String runStorageStr = this.getProperty("-runstorage");
                    this.runstorage = runStorageStr != null ? this.getFile(runStorageStr) : null;
                    String dp = this.getProperty("-dependson");
                    LinkedHashSet<String> requiredProjectNames = new LinkedHashSet<String>(new Parameters(dp).keySet());
                    List<DependencyContributor> dcs = this.getPlugins(DependencyContributor.class);
                    for (DependencyContributor dc : dcs) {
                        dc.addDependencies(this, requiredProjectNames);
                    }
                    Instructions is = new Instructions(requiredProjectNames);
                    HashSet<Instruction> unused = new HashSet<Instruction>();
                    Collection<Project> projects = this.getWorkspace().getAllProjects();
                    Collection<Project> dependencies = is.select(projects, unused, false);
                    for (Instruction u : unused) {
                        this.msgs.MissingDependson_(u.getInput());
                    }
                    this.doPath(this.buildpath, dependencies, this.parseBuildpath(), this.bootclasspath);
                    this.doPath(this.testpath, dependencies, this.parseTestpath(), this.bootclasspath);
                    if (!this.delayRunDependencies) {
                        this.doPath(this.runpath, dependencies, this.parseRunpath(), null);
                        this.doPath(this.runbundles, dependencies, this.parseRunbundles(), null);
                    }
                    HashSet<Project> done = new HashSet<Project>();
                    done.add(this);
                    this.allsourcepath.addAll(this.sourcepath);
                    for (Project project : dependencies) {
                        project.traverse(this.dependson, done);
                    }
                    for (Project project : this.dependson) {
                        this.allsourcepath.addAll(project.getSourcePath());
                    }
                    if (this.isOk()) {
                        this.preparedPaths = true;
                    }
                }
                finally {
                    this.inPrepare = false;
                }
            }
            finally {
                trail.remove(this);
            }
        }
    }

    private File getOutput0() {
        return this.getFile(this.getProperty("bin", "bin")).getAbsoluteFile();
    }

    private File getTarget0() throws IOException {
        File target = this.getFile(this.getProperty("target", "generated"));
        if (!target.exists()) {
            if (!target.mkdirs()) {
                throw new IOException("Could not create directory " + target);
            }
            this.getWorkspace().changedFile(target);
        }
        return target;
    }

    public File getSrc() {
        return new File(this.getBase(), this.getProperty("src", "src"));
    }

    private void traverse(Collection<Project> dependencies, Set<Project> visited) throws Exception {
        if (visited.contains(this)) {
            return;
        }
        visited.add(this);
        for (Project project : this.getDependson()) {
            project.traverse(dependencies, visited);
        }
        dependencies.add(this);
    }

    private void doPath(Collection<Container> resultpath, Collection<Project> projects, Collection<Container> entries, Collection<Container> bootclasspath) {
        for (Container cpe : entries) {
            if (cpe.getError() != null) {
                this.error(cpe.getError(), new Object[0]);
                continue;
            }
            if (cpe.getType() == Container.TYPE.PROJECT) {
                projects.add(cpe.getProject());
            }
            if (bootclasspath != null && (cpe.getBundleSymbolicName().startsWith("ee.") || cpe.getAttributes().containsKey("boot"))) {
                bootclasspath.add(cpe);
                continue;
            }
            resultpath.add(cpe);
        }
    }

    private List<Container> parseBuildpath() throws Exception {
        List<Container> bundles = this.getBundles(Strategy.LOWEST, this.getProperty("-buildpath"), "-buildpath");
        return bundles;
    }

    private List<Container> parseRunpath() throws Exception {
        return this.getBundles(Strategy.HIGHEST, this.getProperty("-runpath"), "-runpath");
    }

    private List<Container> parseRunbundles() throws Exception {
        return this.getBundles(Strategy.HIGHEST, this.getProperty("-runbundles"), "-runbundles");
    }

    private List<Container> parseTestpath() throws Exception {
        return this.getBundles(Strategy.HIGHEST, this.getProperty("-testpath"), "-testpath");
    }

    /*
     * Unable to fully structure code
     */
    public List<Container> getBundles(Strategy strategyx, String spec, String source) throws Exception {
        result = new ArrayList<Container>();
        bundles = new Parameters(spec);
        try {
            for (Map.Entry<String, Attrs> entry : bundles.entrySet()) {
                block14: {
                    bsn = Project.removeDuplicateMarker(entry.getKey());
                    attrs = entry.getValue();
                    found = null;
                    versionRange = (String)attrs.get("version");
                    if (versionRange != null && (versionRange.equals("latest") || versionRange.equals("snapshot"))) {
                        found = this.getBundle(bsn, versionRange, strategyx, attrs);
                    }
                    if (found != null) break block14;
                    if (versionRange == null || !versionRange.equals("project") && !versionRange.equals("latest")) ** GOTO lbl21
                    project = this.getWorkspace().getProject(bsn);
                    if (project != null && project.exists()) {
                        f = project.getOutput();
                        found = new Container(project, bsn, versionRange, Container.TYPE.PROJECT, f, null, attrs, null);
                    } else {
                        this.msgs.NoSuchProject(bsn, spec);
                        continue;
lbl21:
                        // 1 sources

                        if (versionRange != null && versionRange.equals("file")) {
                            f = this.getFile(bsn);
                            error = null;
                            if (!f.exists()) {
                                error = "File does not exist: " + f.getAbsolutePath();
                            }
                            found = f.getName().endsWith(".lib") ? new Container(this, bsn, "file", Container.TYPE.LIBRARY, f, error, attrs, null) : new Container(this, bsn, "file", Container.TYPE.EXTERNAL, f, error, attrs, null);
                        } else {
                            found = this.getBundle(bsn, versionRange, strategyx, attrs);
                        }
                    }
                }
                if (found != null) {
                    libs = found.getMembers();
                    for (Container cc : libs) {
                        if (result.contains(cc)) {
                            this.warning("Multiple bundles with the same final URL: %s, dropped duplicate", new Object[]{cc});
                            continue;
                        }
                        result.add(cc);
                    }
                    continue;
                }
                x = new Container(this, bsn, versionRange, Container.TYPE.ERROR, null, bsn + ";version=" + versionRange + " not found", attrs, null);
                result.add(x);
                this.warning("Can not find URL for bsn " + bsn, new Object[0]);
            }
        }
        catch (CircularDependencyException e) {
            message = e.getMessage();
            if (source != null) {
                message = String.format("%s (from property: %s)", new Object[]{message, source});
            }
            this.msgs.CircularDependencyContext_Message_(this.getName(), message);
        }
        catch (Exception e) {
            this.msgs.Unexpected_Error_(spec, e);
        }
        return result;
    }

    Collection<Container> getBundles(Strategy strategy, String spec) throws Exception {
        return this.getBundles(strategy, spec, null);
    }

    static void mergeNames(String names, Set<String> set) {
        StringTokenizer tokenizer = new StringTokenizer(names, ",");
        while (tokenizer.hasMoreTokens()) {
            set.add(tokenizer.nextToken().trim());
        }
    }

    static String flatten(Set<String> names) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String name : names) {
            if (!first) {
                builder.append(',');
            }
            builder.append(name);
            first = false;
        }
        return builder.toString();
    }

    static void addToPackageList(Container container, String newPackageNames) {
        HashSet<String> merged = new HashSet<String>();
        String packageListStr = container.attributes.get("packages");
        if (packageListStr != null) {
            Project.mergeNames(packageListStr, merged);
        }
        if (newPackageNames != null) {
            Project.mergeNames(newPackageNames, merged);
        }
        container.putAttribute("packages", Project.flatten(merged));
    }

    public void doMavenPom(Strategy strategyx, List<Container> result, String action) throws Exception {
        File pomFile = this.getFile("pom.xml");
        if (!pomFile.isFile()) {
            this.msgs.MissingPom();
        } else {
            ProjectPom pom = this.getWorkspace().getMaven().createProjectModel(pomFile);
            if (action == null) {
                action = "compile";
            }
            Pom.Scope act = Pom.Scope.valueOf(action);
            Set<Pom> dependencies = pom.getDependencies(act);
            for (Pom sub : dependencies) {
                File artifact = sub.getArtifact();
                Container container = new Container(artifact, null);
                result.add(container);
            }
        }
    }

    public Collection<Project> getDependson() throws Exception {
        this.prepare();
        return this.dependson;
    }

    public Collection<Container> getBuildpath() throws Exception {
        this.prepare();
        return this.buildpath;
    }

    public Collection<Container> getTestpath() throws Exception {
        this.prepare();
        return this.testpath;
    }

    private void justInTime(Collection<Container> path, List<Container> entries) {
        if (this.delayRunDependencies && path.isEmpty()) {
            this.doPath(path, this.dependson, entries, null);
        }
    }

    public Collection<Container> getRunpath() throws Exception {
        this.prepare();
        this.justInTime(this.runpath, this.parseRunpath());
        return this.runpath;
    }

    public Collection<Container> getRunbundles() throws Exception {
        this.prepare();
        this.justInTime(this.runbundles, this.parseRunbundles());
        return this.runbundles;
    }

    public File getRunStorage() throws Exception {
        this.prepare();
        return this.runstorage;
    }

    public boolean getRunBuilds() {
        String runBuildsStr = this.getProperty("-runbuilds");
        boolean result = runBuildsStr == null ? !this.getPropertiesFile().getName().toLowerCase().endsWith(".bndrun") : Boolean.parseBoolean(runBuildsStr);
        return result;
    }

    public Collection<File> getSourcePath() throws Exception {
        this.prepare();
        return this.sourcepath;
    }

    public Collection<File> getAllsourcepath() throws Exception {
        this.prepare();
        return this.allsourcepath;
    }

    public Collection<Container> getBootclasspath() throws Exception {
        this.prepare();
        return this.bootclasspath;
    }

    public File getOutput() throws Exception {
        this.prepare();
        return this.output;
    }

    private void doEclipseClasspath() throws Exception {
        EclipseClasspath eclipse = new EclipseClasspath(this, this.getWorkspace().getBase(), this.getBase());
        eclipse.setRecurse(false);
        for (File dependent : eclipse.getDependents()) {
            Project required = this.workspace.getProject(dependent.getName());
            this.dependson.add(required);
        }
        for (File f : eclipse.getClasspath()) {
            this.buildpath.add(new Container(f, null));
        }
        for (File f : eclipse.getBootclasspath()) {
            this.bootclasspath.add(new Container(f, null));
        }
        this.sourcepath.addAll(eclipse.getSourcepath());
        this.allsourcepath.addAll(eclipse.getAllSources());
        this.output = eclipse.getOutput();
    }

    public String _p_dependson(String[] args) throws Exception {
        return this.list(args, this.toFiles(this.getDependson()));
    }

    private Collection<?> toFiles(Collection<Project> projects) {
        ArrayList<File> files = new ArrayList<File>();
        for (Project p : projects) {
            files.add(p.getBase());
        }
        return files;
    }

    public String _p_buildpath(String[] args) throws Exception {
        return this.list(args, this.getBuildpath());
    }

    public String _p_testpath(String[] args) throws Exception {
        return this.list(args, this.getRunpath());
    }

    public String _p_sourcepath(String[] args) throws Exception {
        return this.list(args, this.getSourcePath());
    }

    public String _p_allsourcepath(String[] args) throws Exception {
        return this.list(args, this.getAllsourcepath());
    }

    public String _p_bootclasspath(String[] args) throws Exception {
        return this.list(args, this.getBootclasspath());
    }

    public String _p_output(String[] args) throws Exception {
        if (args.length != 1) {
            throw new IllegalArgumentException("${output} should not have arguments");
        }
        return this.getOutput().getAbsolutePath();
    }

    private String list(String[] args, Collection<?> list) {
        if (args.length > 3) {
            throw new IllegalArgumentException("${" + args[0] + "[;<separator>]} can only take a separator as argument, has " + Arrays.toString(args));
        }
        String separator = ",";
        if (args.length == 2) {
            separator = args[1];
        }
        return Project.join(list, separator);
    }

    @Override
    protected Object[] getMacroDomains() {
        return new Object[]{this.workspace};
    }

    public File release(String jarName, InputStream jarStream) throws Exception {
        String name = this.getProperty("-releaserepo");
        return this.release(name, jarName, jarStream);
    }

    public URI releaseURI(String jarName, InputStream jarStream) throws Exception {
        String name = this.getProperty("-releaserepo");
        return this.releaseURI(name, jarName, jarStream);
    }

    public File release(String name, String jarName, InputStream jarStream) throws Exception {
        URI uri = this.releaseURI(name, jarName, jarStream);
        if (uri != null) {
            return new File(uri);
        }
        return null;
    }

    public URI releaseURI(String name, String jarName, InputStream jarStream) throws Exception {
        this.trace("release to %s", name);
        RepositoryPlugin repo = this.getReleaseRepo(name);
        if (repo == null) {
            if (name == null) {
                this.msgs.NoNameForReleaseRepository();
            } else {
                this.msgs.ReleaseRepository_NotFoundIn_(name, this.getPlugins(RepositoryPlugin.class));
            }
            return null;
        }
        try {
            RepositoryPlugin.PutResult r = repo.put(jarStream, new RepositoryPlugin.PutOptions());
            this.trace("Released %s to %s in repository %s", jarName, r.artifact, repo);
            return r.artifact;
        }
        catch (Exception e) {
            this.msgs.Release_Into_Exception_(jarName, repo, e);
            return null;
        }
    }

    RepositoryPlugin getReleaseRepo(String releaserepo) {
        String name;
        name = releaserepo == null ? (name = this.getProperty("-releaserepo")) : releaserepo;
        List<RepositoryPlugin> plugins = this.getPlugins(RepositoryPlugin.class);
        for (RepositoryPlugin plugin : plugins) {
            if (!plugin.canWrite()) continue;
            if (name == null) {
                return plugin;
            }
            if (!name.equals(plugin.getName())) continue;
            return plugin;
        }
        return null;
    }

    public void release(boolean test) throws Exception {
        String name = this.getProperty("-releaserepo");
        this.release(name, test);
    }

    public void release(String name, boolean test) throws Exception {
        this.trace("release", new Object[0]);
        Object[] jars = this.build(test);
        if (jars == null) {
            this.trace("no jars being build", new Object[0]);
            return;
        }
        this.trace("build ", Arrays.toString(jars));
        for (Object jar : jars) {
            this.release(name, ((File)jar).getName(), new BufferedInputStream(new FileInputStream((File)jar)));
        }
    }

    public Container getBundle(String bsn, String range, Strategy strategy, Map<String, String> attrs) throws Exception {
        if (range == null) {
            range = "0";
        }
        if ("snapshot".equals(range)) {
            return this.getBundleFromProject(bsn, attrs);
        }
        Strategy useStrategy = strategy;
        if ("latest".equals(range)) {
            Container c = this.getBundleFromProject(bsn, attrs);
            if (c != null) {
                return c;
            }
            useStrategy = Strategy.HIGHEST;
        }
        useStrategy = this.overrideStrategy(attrs, useStrategy);
        List<RepositoryPlugin> plugins = this.workspace.getRepositories();
        if (useStrategy == Strategy.EXACT) {
            if (!Verifier.isVersion(range)) {
                return new Container(this, bsn, range, Container.TYPE.ERROR, null, bsn + ";version=" + range + " Invalid version", null, null);
            }
            Version version = new Version(range);
            for (RepositoryPlugin plugin : plugins) {
                DownloadBlocker blocker;
                File result = plugin.get(bsn, version, attrs, blocker = new DownloadBlocker(this));
                if (result == null) continue;
                return this.toContainer(bsn, range, attrs, result, blocker);
            }
        } else {
            VersionRange versionRange = "latest".equals(range) ? new VersionRange("0") : new VersionRange(range);
            TreeMap<Version, RepositoryPlugin> versions = new TreeMap<Version, RepositoryPlugin>();
            for (RepositoryPlugin plugin : plugins) {
                try {
                    SortedSet<Version> vs = plugin.versions(bsn);
                    if (vs == null) continue;
                    for (Version v : vs) {
                        if (versions.containsKey(v) || !versionRange.includes(v)) continue;
                        versions.put(v, plugin);
                    }
                }
                catch (UnsupportedOperationException ose) {
                    DownloadBlocker blocker;
                    Version version;
                    File file;
                    if (versions.isEmpty() || !Verifier.isVersion(range) || (file = plugin.get(bsn, version = new Version(range), attrs, blocker = new DownloadBlocker(this))) == null) continue;
                    return this.toContainer(bsn, range, attrs, file, blocker);
                }
            }
            if (!versions.isEmpty()) {
                Version provider = null;
                switch (useStrategy) {
                    case HIGHEST: {
                        provider = (Version)versions.lastKey();
                        break;
                    }
                    case LOWEST: {
                        provider = (Version)versions.firstKey();
                        break;
                    }
                }
                if (provider != null) {
                    RepositoryPlugin repo = (RepositoryPlugin)versions.get(provider);
                    String version = provider.toString();
                    DownloadBlocker blocker = new DownloadBlocker(this);
                    File result = repo.get(bsn, provider, attrs, blocker);
                    if (result != null) {
                        return this.toContainer(bsn, version, attrs, result, blocker);
                    }
                } else {
                    this.msgs.FoundVersions_ForStrategy_ButNoProvider(versions, useStrategy);
                }
            }
        }
        return new Container(this, bsn, range, Container.TYPE.ERROR, null, bsn + ";version=" + range + " Not found in " + plugins, null, null);
    }

    protected Strategy overrideStrategy(Map<String, String> attrs, Strategy useStrategy) {
        String overrideStrategy;
        if (attrs != null && (overrideStrategy = attrs.get("strategy")) != null) {
            if ("highest".equalsIgnoreCase(overrideStrategy)) {
                useStrategy = Strategy.HIGHEST;
            } else if ("lowest".equalsIgnoreCase(overrideStrategy)) {
                useStrategy = Strategy.LOWEST;
            } else if ("exact".equalsIgnoreCase(overrideStrategy)) {
                useStrategy = Strategy.EXACT;
            }
        }
        return useStrategy;
    }

    protected Container toContainer(String bsn, String range, Map<String, String> attrs, File result, DownloadBlocker db) {
        File f = result;
        if (f == null) {
            this.msgs.ConfusedNoContainerFile();
            f = new File("was null");
        }
        Container container = f.getName().endsWith("lib") ? new Container(this, bsn, range, Container.TYPE.LIBRARY, f, null, attrs, db) : new Container(this, bsn, range, Container.TYPE.REPO, f, null, attrs, db);
        return container;
    }

    private Container getBundleFromProject(String bsn, Map<String, String> attrs) throws Exception {
        String pname = bsn;
        while (true) {
            Project p;
            if ((p = this.getWorkspace().getProject(pname)) != null && p.isValid()) {
                Container c = p.getDeliverable(bsn, attrs);
                return c;
            }
            int n = pname.lastIndexOf(46);
            if (n <= 0) {
                return null;
            }
            pname = pname.substring(0, n);
        }
    }

    public void deploy(String name, File file) throws Exception {
        List<RepositoryPlugin> plugins = this.getPlugins(RepositoryPlugin.class);
        RepositoryPlugin rp = null;
        for (RepositoryPlugin plugin : plugins) {
            if (!plugin.canWrite()) continue;
            if (name == null) {
                rp = plugin;
                break;
            }
            if (!name.equals(plugin.getName())) continue;
            rp = plugin;
            break;
        }
        if (rp != null) {
            try {
                rp.put(new BufferedInputStream(new FileInputStream(file)), new RepositoryPlugin.PutOptions());
                return;
            }
            catch (Exception e) {
                this.msgs.DeployingFile_On_Exception_(file, rp.getName(), e);
                return;
            }
        }
        this.trace("No repo found " + file, new Object[0]);
        throw new IllegalArgumentException("No repository found for " + file);
    }

    public void deploy(File file) throws Exception {
        String name = this.getProperty("-deployrepo");
        this.deploy(name, file);
    }

    public void deploy() throws Exception {
        File[] outputs;
        Parameters deploy = new Parameters(this.getProperty("-deploy"));
        if (deploy.isEmpty()) {
            this.warning("Deploying but %s is not set to any repo", "-deploy");
            return;
        }
        for (File output : outputs = this.getBuildFiles()) {
            for (Deploy d : this.getPlugins(Deploy.class)) {
                this.trace("Deploying %s to: %s", output.getName(), d);
                try {
                    if (!d.deploy(this, output.getName(), new BufferedInputStream(new FileInputStream(output)))) continue;
                    this.trace("deployed %s successfully to %s", output, d);
                }
                catch (Exception e) {
                    this.msgs.Deploying(e);
                }
            }
        }
    }

    public String _repo(String[] args) throws Exception {
        if (args.length < 2) {
            this.msgs.RepoTooFewArguments(_repoHelp, args);
            return null;
        }
        String bsns = args[1];
        String version = null;
        Strategy strategy = Strategy.HIGHEST;
        if (args.length > 2) {
            version = args[2];
            if (args.length == 4) {
                if (args[3].equalsIgnoreCase("HIGHEST")) {
                    strategy = Strategy.HIGHEST;
                } else if (args[3].equalsIgnoreCase("LOWEST")) {
                    strategy = Strategy.LOWEST;
                } else if (args[3].equalsIgnoreCase("EXACT")) {
                    strategy = Strategy.EXACT;
                } else {
                    this.msgs.InvalidStrategy(_repoHelp, args);
                }
            }
        }
        Collection<String> parts = Project.split(bsns);
        ArrayList<String> paths = new ArrayList<String>();
        for (String bsn : parts) {
            Container container = this.getBundle(bsn, version, strategy, null);
            this.add(paths, container);
        }
        return Project.join(paths);
    }

    private void add(List<String> paths, Container container) throws Exception {
        if (container.getType() == Container.TYPE.LIBRARY) {
            List<Container> members = container.getMembers();
            for (Container sub : members) {
                this.add(paths, sub);
            }
        } else if (container.getError() == null) {
            paths.add(container.getFile().getAbsolutePath());
        } else {
            paths.add("<<${repo} = " + container.getBundleSymbolicName() + "-" + container.getVersion() + " : " + container.getError() + ">>");
            if (this.isPedantic()) {
                this.warning("Could not expand repo path request: %s ", container);
            }
        }
    }

    public File getTarget() throws Exception {
        this.prepare();
        return this.target;
    }

    public File[] build(boolean underTest) throws Exception {
        if (this.isNoBundles()) {
            return null;
        }
        if (this.getProperty("-nope") != null) {
            this.warning("Please replace -nope with %s", "-nobundles");
            return null;
        }
        if (this.isStale()) {
            this.trace("building " + this, new Object[0]);
            this.files = this.buildLocal(underTest);
        }
        return this.files;
    }

    public File[] getFiles() {
        return this.files;
    }

    public boolean isStale() throws Exception {
        if (this.workspace.isOffline()) {
            this.trace("working %s offline, so always stale", this);
            return true;
        }
        HashSet<Project> visited = new HashSet<Project>();
        return this.isStale(visited);
    }

    boolean isStale(Set<Project> visited) throws Exception {
        if (this.isNoBundles()) {
            return false;
        }
        if (visited.contains(this)) {
            this.msgs.CircularDependencyContext_Message_(this.getName(), visited.toString());
            return false;
        }
        visited.add(this);
        long buildTime = 0L;
        this.files = this.getBuildFiles(false);
        if (this.files == null) {
            return true;
        }
        for (File f : this.files) {
            if (f.lastModified() < this.lastModified()) {
                return true;
            }
            if (buildTime >= f.lastModified()) continue;
            buildTime = f.lastModified();
        }
        for (Project dependency : this.getDependson()) {
            File[] deps;
            if (dependency == this) continue;
            if (dependency.isStale()) {
                return true;
            }
            if (dependency.isNoBundles()) continue;
            for (File f : deps = dependency.getBuildFiles()) {
                if (f.lastModified() < buildTime) continue;
                return true;
            }
        }
        return false;
    }

    public File[] getBuildFiles() throws Exception {
        return this.getBuildFiles(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getBuildFiles(boolean buildIfAbsent) throws Exception {
        if (this.files != null) {
            return this.files;
        }
        File f = new File(this.getTarget(), "buildfiles");
        if (f.isFile()) {
            BufferedReader rdr = IO.reader(f);
            try {
                List<File> files = this.newList();
                String s = rdr.readLine();
                while (s != null) {
                    File ff = new File(s = s.trim());
                    if (!ff.isFile()) {
                        rdr.close();
                        f.delete();
                        break;
                    }
                    files.add(ff);
                    s = rdr.readLine();
                }
                this.files = files.toArray(new File[files.size()]);
                File[] fileArray = this.files;
                return fileArray;
            }
            finally {
                rdr.close();
            }
        }
        if (buildIfAbsent) {
            this.files = this.buildLocal(false);
            return this.files;
        }
        this.files = null;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] buildLocal(boolean underTest) throws Exception {
        if (this.isNoBundles()) {
            return null;
        }
        File bfs = new File(this.getTarget(), "buildfiles");
        bfs.delete();
        this.files = null;
        ProjectBuilder builder = this.getBuilder(null);
        try {
            if (underTest) {
                builder.setProperty("-undertest", "true");
            }
            Jar[] jars = builder.builds();
            File[] files = new File[jars.length];
            this.getInfo(builder);
            if (this.isOk()) {
                this.files = files;
                for (int i = 0; i < jars.length; ++i) {
                    Jar jar = jars[i];
                    files[i] = this.saveBuild(jar);
                }
                PrintWriter fw = IO.writer(bfs);
                try {
                    for (File f : files) {
                        ((Writer)fw).append(f.getAbsolutePath());
                        ((Writer)fw).append("\n");
                    }
                }
                finally {
                    ((Writer)fw).close();
                }
                this.getWorkspace().changedFile(bfs);
                File[] fileArray = files;
                return fileArray;
            }
            File[] fileArray = null;
            return fileArray;
        }
        finally {
            builder.close();
        }
    }

    public boolean isNoBundles() {
        return this.getProperty("-nobundles") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveBuild(Jar jar) throws Exception {
        try {
            String bsn = jar.getName();
            File f = this.getOutputFile(bsn);
            String msg = "";
            if (!f.exists() || f.lastModified() < jar.lastModified()) {
                this.reportNewer(f.lastModified(), jar);
                f.delete();
                File fp = f.getParentFile();
                if (!(fp.isDirectory() || fp.exists() || fp.mkdirs())) {
                    throw new IOException("Could not create directory " + fp);
                }
                jar.write(f);
                this.getWorkspace().changedFile(f);
            } else {
                msg = "(not modified since " + new Date(f.lastModified()) + ")";
            }
            this.trace(jar.getName() + " (" + f.getName() + ") " + jar.getResources().size() + " " + msg, new Object[0]);
            File file = f;
            return file;
        }
        finally {
            jar.close();
        }
    }

    public File getOutputFile(String bsn) throws Exception {
        return new File(this.getTarget(), bsn + ".jar");
    }

    private void reportNewer(long lastModified, Jar jar) {
        if (Project.isTrue(this.getProperty("-reportnewer"))) {
            StringBuilder sb = new StringBuilder();
            String del = "Newer than " + new Date(lastModified);
            for (Map.Entry<String, Resource> entry : jar.getResources().entrySet()) {
                if (entry.getValue().lastModified() <= lastModified) continue;
                sb.append(del);
                del = ", \n     ";
                sb.append(entry.getKey());
            }
            if (sb.length() > 0) {
                this.warning(sb.toString(), new Object[0]);
            }
        }
    }

    @Override
    public boolean refresh() {
        boolean changed = false;
        if (this.isCnf()) {
            changed = this.workspace.refresh();
        }
        return super.refresh() || changed;
    }

    public boolean isCnf() {
        return this.getBase().getName().equals(BNDCNF);
    }

    @Override
    public void propertiesChanged() {
        super.propertiesChanged();
        this.preparedPaths = false;
        this.files = null;
    }

    public String getName() {
        return this.getBase().getName();
    }

    public Map<String, Action> getActions() {
        Map<String, Action> all = Project.newMap();
        Map<String, Action> actions = Project.newMap();
        this.fillActions(all);
        this.getWorkspace().fillActions(all);
        for (Map.Entry<String, Action> action : all.entrySet()) {
            String key = this.getReplacer().process(action.getKey());
            if (key == null || key.trim().length() == 0) continue;
            actions.put(key, action.getValue());
        }
        return actions;
    }

    public void fillActions(Map<String, Action> all) {
        List<NamedAction> plugins = this.getPlugins(NamedAction.class);
        for (NamedAction a : plugins) {
            all.put(a.getName(), a);
        }
        Parameters actions = new Parameters(this.getProperty("-actions", DEFAULT_ACTIONS));
        for (Map.Entry<String, Attrs> entry : actions.entrySet()) {
            String key = Processor.removeDuplicateMarker(entry.getKey());
            Action action = entry.getValue().get("script") != null ? new ScriptAction(entry.getValue().get("type"), entry.getValue().get("script")) : new ReflectAction(key);
            String label = entry.getValue().get("label");
            all.put(label.toLowerCase(), action);
        }
    }

    public void release() throws Exception {
        this.release(false);
    }

    public void release(String name) throws Exception {
        this.release(name, false);
    }

    public void clean() throws Exception {
        File target = this.getTarget0();
        if (target.isDirectory() && target.getParentFile() != null) {
            IO.delete(target);
            if (!target.exists() && !target.mkdirs()) {
                throw new IOException("Could not create directory " + target);
            }
        }
        File output = this.getOutput0();
        if (this.getOutput().isDirectory()) {
            IO.delete(output);
        }
        if (!output.exists() && !output.mkdirs()) {
            throw new IOException("Could not create directory " + output);
        }
    }

    public File[] build() throws Exception {
        return this.build(false);
    }

    public void run() throws Exception {
        ProjectLauncher pl = this.getProjectLauncher();
        pl.setTrace(this.isTrace());
        pl.launch();
    }

    public void test() throws Exception {
        String testcases = this.get("Test-Cases");
        if (testcases == null) {
            this.warning("No %s set", "Test-Cases");
            return;
        }
        this.clear();
        ProjectTester tester = this.getProjectTester();
        tester.setContinuous(Project.isTrue(this.getProperty("-testcontinuous")));
        tester.prepare();
        if (!this.isOk()) {
            return;
        }
        int errors = tester.test();
        if (errors == 0) {
            System.err.println("No Errors");
        } else if (errors > 0) {
            System.err.println(errors + " Error(s)");
        } else {
            System.err.println("Error " + errors);
        }
    }

    public Jar getValidJar(File f) throws Exception {
        Jar jar = new Jar(f);
        return this.getValidJar(jar, f.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Jar getValidJar(URL url) throws Exception {
        InputStream in = url.openStream();
        try {
            Jar jar = new Jar(url.getFile().replace('/', '.'), in, System.currentTimeMillis());
            Jar jar2 = this.getValidJar(jar, ((Object)url).toString());
            return jar2;
        }
        finally {
            in.close();
        }
    }

    public Jar getValidJar(Jar jar, String id) throws Exception {
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            this.trace("Wrapping with all defaults", new Object[0]);
            Builder b = new Builder(this);
            b.addClasspath(jar);
            b.setProperty("Bnd-Message", "Wrapped from " + id + "because lacked manifest");
            b.setProperty("Export-Package", "*");
            b.setProperty("Import-Package", "*;resolution:=optional");
            jar = b.build();
        } else if (manifest.getMainAttributes().getValue("Bundle-ManifestVersion") == null) {
            this.trace("Not a release 4 bundle, wrapping with manifest as source", new Object[0]);
            Builder b = new Builder(this);
            b.addClasspath(jar);
            b.setProperty("Private-Package", "*");
            b.mergeManifest(manifest);
            String imprts = manifest.getMainAttributes().getValue("Import-Package");
            imprts = imprts == null ? "" : imprts + ",";
            imprts = imprts + "*;resolution=optional";
            b.setProperty("Import-Package", imprts);
            b.setProperty("Bnd-Message", "Wrapped from " + id + "because had incomplete manifest");
            jar = b.build();
        }
        return jar;
    }

    public String _project(String[] args) {
        return this.getBase().getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bump(String mask) throws Exception {
        String pattern = "(Bundle-Version\\s*(:|=)\\s*)(([0-9]+(\\.[0-9]+(\\.[0-9]+)?)?))";
        String replace = "$1${version;" + mask + ";$3}";
        try {
            if (this.replace(this.getPropertiesFile(), pattern, replace)) {
                return;
            }
            this.trace("no version in bnd.bnd", new Object[0]);
            List<File> included = this.getIncluded();
            if (included != null) {
                ArrayList<File> copy = new ArrayList<File>(included);
                Collections.reverse(copy);
                for (File file : copy) {
                    if (!this.replace(file, pattern, replace)) continue;
                    this.trace("replaced version in file %s", file);
                    return;
                }
            }
            this.trace("no version in included files", new Object[0]);
            boolean found = false;
            for (Builder builder : this.getSubBuilders()) {
                found |= this.replace(builder.getPropertiesFile(), pattern, replace);
            }
            if (!found) {
                this.trace("no version in sub builders, add it to bnd.bnd", new Object[0]);
                String bndfile = IO.collect(this.getPropertiesFile());
                bndfile = bndfile + "\n# Added by by bump\nBundle-Version: 0.0.0\n";
                IO.store((Object)bndfile, this.getPropertiesFile());
            }
        }
        finally {
            this.forceRefresh();
        }
    }

    boolean replace(File f, String pattern, String replacement) throws IOException {
        final Macro macro = this.getReplacer();
        Sed sed = new Sed(new Replacer(){

            public String process(String line) {
                return macro.process(line);
            }
        }, f);
        sed.replace(pattern, replacement);
        return sed.doIt() > 0;
    }

    public void bump() throws Exception {
        this.bump(this.getProperty("-bumppolicy", "=+0"));
    }

    public void action(String command) throws Throwable {
        Map<String, Action> actions = this.getActions();
        Action a = actions.get(command);
        if (a == null) {
            a = new ReflectAction(command);
        }
        this.before(this, command);
        try {
            a.execute(this, command);
        }
        catch (Throwable t) {
            this.after(this, command, t);
            throw t;
        }
    }

    void before(Project p, String a) {
        List<CommandPlugin> testPlugins = this.getPlugins(CommandPlugin.class);
        for (CommandPlugin testPlugin : testPlugins) {
            testPlugin.before(this, a);
        }
    }

    void after(Project p, String a, Throwable t) {
        List<CommandPlugin> testPlugins = this.getPlugins(CommandPlugin.class);
        for (int i = testPlugins.size() - 1; i >= 0; --i) {
            testPlugins.get(i).after(this, a, t);
        }
    }

    public String _findfile(String[] args) {
        File f = this.getFile(args[1]);
        ArrayList<String> files = new ArrayList<String>();
        this.tree(files, f, "", new Instruction(args[2]));
        return Project.join(files);
    }

    void tree(List<String> list, File current, String path, Instruction instr) {
        String[] subs;
        if (path.length() > 0) {
            path = path + "/";
        }
        if ((subs = current.list()) != null) {
            for (String sub : subs) {
                File f = new File(current, sub);
                if (f.isFile()) {
                    if (!instr.matches(sub) || instr.isNegated()) continue;
                    list.add(path + sub);
                    continue;
                }
                this.tree(list, f, path + sub, instr);
            }
        }
    }

    public void refreshAll() {
        this.workspace.refresh();
        this.refresh();
    }

    public void script(String type, String script) throws Exception {
        List<Scripter> scripters = this.getPlugins(Scripter.class);
        if (scripters.isEmpty()) {
            this.msgs.NoScripters_(script);
            return;
        }
        Properties x = this.getProperties();
        scripters.get(0).eval(x, new StringReader(script));
    }

    public String _repos(String[] args) throws Exception {
        List<RepositoryPlugin> repos = this.getPlugins(RepositoryPlugin.class);
        ArrayList<String> names = new ArrayList<String>();
        for (RepositoryPlugin rp : repos) {
            names.add(rp.getName());
        }
        return Project.join(names, ", ");
    }

    public String _help(String[] args) throws Exception {
        if (args.length == 1) {
            return "Specify the option or header you want information for";
        }
        Syntax syntax = Syntax.HELP.get(args[1]);
        if (syntax == null) {
            return "No help for " + args[1];
        }
        String what = null;
        if (args.length > 2) {
            what = args[2];
        }
        if (what == null || what.equals("lead")) {
            return syntax.getLead();
        }
        if (what.equals("example")) {
            return syntax.getExample();
        }
        if (what.equals("pattern")) {
            return syntax.getPattern();
        }
        if (what.equals("values")) {
            return syntax.getValues();
        }
        return "Invalid type specified for help: lead, example, pattern, values";
    }

    public Collection<Container> getDeliverables() throws Exception {
        ArrayList<Container> result = new ArrayList<Container>();
        Collection<? extends Builder> builders = this.getSubBuilders();
        for (Builder builder : builders) {
            Container c = new Container(this, builder.getBsn(), builder.getVersion(), Container.TYPE.PROJECT, this.getOutputFile(builder.getBsn()), null, null, null);
            result.add(c);
        }
        return result;
    }

    public Builder getSubBuilder(File bndFile) throws Exception {
        bndFile = bndFile.getCanonicalFile();
        File base = this.getBase().getCanonicalFile();
        if (!bndFile.getAbsolutePath().startsWith(base.getAbsolutePath())) {
            return null;
        }
        Collection<? extends Builder> builders = this.getSubBuilders();
        for (Builder builder : builders) {
            File propertiesFile = builder.getPropertiesFile();
            if (propertiesFile == null || !((Object)propertiesFile.getCanonicalFile()).equals(bndFile)) continue;
            return builder;
        }
        return null;
    }

    public Container getDeliverable(String bsn, Map<String, String> attrs) throws Exception {
        Collection<? extends Builder> builders = this.getSubBuilders();
        for (Builder builder : builders) {
            if (!builder.getBsn().equals(bsn)) continue;
            return new Container(this, this.getOutputFile(bsn));
        }
        return null;
    }

    public Collection<? extends Builder> getSubBuilders() throws Exception {
        return this.getBuilder(null).getSubBuilders();
    }

    Collection<File> toFile(Collection<Container> containers) throws Exception {
        ArrayList<File> files = new ArrayList<File>();
        for (Container container : containers) {
            container.contributeFiles(files, this);
        }
        return files;
    }

    public Collection<String> getRunVM() {
        Parameters hdr = this.getParameters("-runvm");
        return hdr.keySet();
    }

    public Collection<String> getRunProgramArgs() {
        Parameters hdr = this.getParameters("-runprogramargs");
        return hdr.keySet();
    }

    public Map<String, String> getRunProperties() {
        return OSGiHeader.parseProperties(this.getProperty("-runproperties"));
    }

    public ProjectLauncher getProjectLauncher() throws Exception {
        return this.getHandler(ProjectLauncher.class, this.getRunpath(), "Launcher-Plugin", "biz.aQute.launcher");
    }

    public ProjectTester getProjectTester() throws Exception {
        return this.getHandler(ProjectTester.class, this.getTestpath(), "Tester-Plugin", "biz.aQute.junit");
    }

    private <T> T getHandler(Class<T> target, Collection<Container> containers, String header, String defaultHandler) throws Exception {
        Class<T> handlerClass = target;
        List<Container> withDefault = Create.list();
        withDefault.addAll(containers);
        withDefault.addAll(this.getBundles(Strategy.HIGHEST, defaultHandler, null));
        this.trace("candidates for tester %s", withDefault);
        for (Container c : withDefault) {
            Class<?> clz;
            String launcher;
            Manifest manifest = c.getManifest();
            if (manifest == null || (launcher = manifest.getMainAttributes().getValue(header)) == null || (clz = this.getClass(launcher, c.getFile())) == null) continue;
            if (!target.isAssignableFrom(clz)) {
                this.msgs.IncompatibleHandler_For_(launcher, defaultHandler);
                continue;
            }
            handlerClass = clz.asSubclass(target);
            Constructor<T> constructor = handlerClass.getConstructor(Project.class);
            return constructor.newInstance(this);
        }
        throw new IllegalArgumentException("Default handler for " + header + " not found in " + defaultHandler);
    }

    public void setDelayRunDependencies(boolean x) {
        this.delayRunDependencies = x;
    }

    public void setPackageInfo(String packageName, Version version) {
        try {
            Version current = this.getPackageInfoJavaVersion(packageName);
            boolean packageInfoJava = false;
            if (current != null) {
                this.updatePackageInfoJavaFile(packageName, version);
                packageInfoJava = true;
            }
            if (!packageInfoJava || this.getPackageInfoFile(packageName).exists()) {
                this.updatePackageInfoFile(packageName, version);
            }
        }
        catch (Exception e) {
            this.msgs.SettingPackageInfoException_(e);
        }
    }

    void updatePackageInfoJavaFile(String packageName, final Version newVersion) throws Exception {
        File file = this.getPackageInfoJavaFile(packageName);
        if (!file.exists()) {
            return;
        }
        if (!file.getParentFile().exists()) {
            return;
        }
        Version oldVersion = this.getPackageInfo(packageName);
        if (newVersion.compareTo(oldVersion) == 0) {
            return;
        }
        Sed sed = new Sed(new Replacer(){

            public String process(String line) {
                Matcher m = VERSION_ANNOTATION.matcher(line);
                if (m.find()) {
                    return line.substring(0, m.start(3)) + newVersion.toString() + line.substring(m.end(3));
                }
                return line;
            }
        }, file);
        sed.replace(VERSION_ANNOTATION.pattern(), "$0");
        sed.setBackup(false);
        sed.doIt();
    }

    void updatePackageInfoFile(String packageName, Version newVersion) throws Exception {
        File file = this.getPackageInfoFile(packageName);
        if (!file.getParentFile().exists()) {
            return;
        }
        Version oldVersion = this.getPackageInfoVersion(packageName);
        if (oldVersion == null) {
            oldVersion = Version.emptyVersion;
        }
        if (newVersion.compareTo(oldVersion) == 0) {
            return;
        }
        PrintWriter pw = IO.writer(file);
        pw.println("version " + newVersion);
        pw.flush();
        pw.close();
        String path = packageName.replace('.', '/') + "/packageinfo";
        File binary = IO.getFile(this.getOutput(), path);
        File bp = binary.getParentFile();
        if (!bp.exists() && !bp.mkdirs()) {
            throw new IOException("Could not create directory " + bp);
        }
        IO.copy(file, binary);
    }

    File getPackageInfoFile(String packageName) {
        String path = packageName.replace('.', '/') + "/packageinfo";
        return IO.getFile(this.getSrc(), path);
    }

    File getPackageInfoJavaFile(String packageName) {
        String path = packageName.replace('.', '/') + "/package-info.java";
        return IO.getFile(this.getSrc(), path);
    }

    public Version getPackageInfo(String packageName) throws IOException {
        Version version = this.getPackageInfoJavaVersion(packageName);
        if (version != null) {
            return version;
        }
        version = this.getPackageInfoVersion(packageName);
        if (version != null) {
            return version;
        }
        return Version.emptyVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Version getPackageInfoVersion(String packageName) throws IOException {
        File packageInfoFile = this.getPackageInfoFile(packageName);
        if (!packageInfoFile.exists()) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = IO.reader(packageInfoFile);
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).startsWith("version ")) continue;
                Version version = Version.parseVersion(line.substring(8));
                return version;
            }
        }
        finally {
            if (reader != null) {
                IO.close(reader);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Version getPackageInfoJavaVersion(String packageName) throws IOException {
        File packageInfoJavaFile = this.getPackageInfoJavaFile(packageName);
        if (!packageInfoJavaFile.exists()) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = IO.reader(packageInfoJavaFile);
            while ((line = reader.readLine()) != null) {
                Matcher matcher = VERSION_ANNOTATION.matcher(line);
                if (!matcher.find()) continue;
                Version version = Version.parseVersion(matcher.group(3));
                return version;
            }
        }
        finally {
            if (reader != null) {
                IO.close(reader);
            }
        }
        return null;
    }

    public void addClasspath(File f) {
        if (!f.isFile() && !f.isDirectory()) {
            this.msgs.AddingNonExistentFileToClassPath_(f);
        }
        Container container = new Container(f, null);
        this.classpath.add(container);
    }

    public void clearClasspath() {
        this.classpath.clear();
    }

    public Collection<Container> getClasspath() {
        return this.classpath;
    }
}

