/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.mbeans.packages.internal;

import java.util.ArrayList;
import java.util.List;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.karaf.management.mbeans.packages.PackagesMBean;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagesMBeanImpl
extends StandardMBean
implements PackagesMBean {
    private BundleContext bundleContext;

    public PackagesMBeanImpl() throws NotCompliantMBeanException {
        super(PackagesMBean.class);
    }

    @Override
    public List<String> getExports() throws Exception {
        return this.getExports(-1L);
    }

    @Override
    public List<String> getExports(long bundleId) throws Exception {
        ArrayList<String> exportPackages = new ArrayList<String>();
        ServiceReference ref = this.bundleContext.getServiceReference(PackageAdmin.class.getName());
        if (ref == null) {
            throw new IllegalStateException("PackageAdmin is not available");
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.bundleContext.getService(ref);
        if (packageAdmin == null) {
            throw new IllegalStateException("PackageAdmin is not available");
        }
        Bundle[] bundles = bundleId >= 0L ? new Bundle[]{this.bundleContext.getBundle(bundleId)} : this.bundleContext.getBundles();
        for (Bundle bundle : bundles) {
            ExportedPackage[] packages = packageAdmin.getExportedPackages(bundle);
            if (packages == null) continue;
            for (ExportedPackage exportedPackage : packages) {
                exportPackages.add(exportedPackage.getName());
            }
        }
        return exportPackages;
    }

    @Override
    public List<String> getImports() throws Exception {
        return this.getImports(-1L);
    }

    @Override
    public List<String> getImports(long bundleId) throws Exception {
        ArrayList<String> importPackages = new ArrayList<String>();
        ServiceReference ref = this.bundleContext.getServiceReference(PackageAdmin.class.getName());
        if (ref == null) {
            throw new IllegalStateException("PackageAdmin is not available");
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.bundleContext.getService(ref);
        if (packageAdmin == null) {
            throw new IllegalStateException("PackageAdmin is not available");
        }
        ExportedPackage[] exportedPackages = bundleId >= 0L ? packageAdmin.getExportedPackages(this.bundleContext.getBundle(bundleId)) : packageAdmin.getExportedPackages((Bundle)null);
        if (exportedPackages != null) {
            for (ExportedPackage exportedPackage : exportedPackages) {
                Bundle[] bundles = exportedPackage.getImportingBundles();
                if (bundles == null || bundles.length <= 0) continue;
                importPackages.add(exportedPackage.getName());
            }
        }
        return importPackages;
    }

    @Override
    public List<String> exportedPackages() throws Exception {
        return this.getExports();
    }

    @Override
    public List<String> exportedPackages(long bundleId) throws Exception {
        return this.getExports(bundleId);
    }

    @Override
    public List<String> importedPackages() throws Exception {
        return this.getImports();
    }

    @Override
    public List<String> importedPackages(long bundleId) throws Exception {
        return this.getImports(bundleId);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

