/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.component;

import aQute.bnd.component.AnnotationReader;
import aQute.bnd.component.ComponentDef;
import aQute.bnd.component.TagResource;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.AnalyzerPlugin;
import java.util.ArrayList;
import java.util.HashSet;

public class DSAnnotations
implements AnalyzerPlugin {
    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        Parameters header = OSGiHeader.parseHeader(analyzer.getProperty("-dsannotations"));
        if (header.size() == 0) {
            return false;
        }
        Instructions instructions = new Instructions(header);
        HashSet<Clazz> list = new HashSet<Clazz>(analyzer.getClassspace().values());
        String sc = analyzer.getProperty("Service-Component");
        ArrayList<String> names = new ArrayList<String>();
        if (sc != null && sc.trim().length() > 0) {
            names.add(sc);
        }
        block0: for (Clazz c : list) {
            for (Instruction instruction : instructions.keySet()) {
                if (!instruction.matches(c.getFQN())) continue;
                if (instruction.isNegated()) continue block0;
                ComponentDef definition = AnnotationReader.getDefinition(c, analyzer);
                if (definition == null) continue;
                definition.sortReferences();
                definition.prepare(analyzer);
                String name = "OSGI-INF/" + definition.name + ".xml";
                names.add(name);
                analyzer.getJar().putResource(name, new TagResource(definition.getTag()));
            }
        }
        sc = Processor.append(names.toArray(new String[names.size()]));
        analyzer.setProperty("Service-Component", sc);
        return false;
    }
}

