/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.mina;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.SimpleIoProcessorPool;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.apache.mina.transport.socket.nio.NioSession;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.mina.MinaAcceptor;
import org.apache.sshd.common.io.mina.MinaConnector;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaServiceFactory
extends CloseableUtils.AbstractCloseable
implements IoServiceFactory {
    private final Logger logger = LoggerFactory.getLogger(MinaServiceFactory.class);
    private final FactoryManager manager;
    private final ExecutorService executor;
    private final IoProcessor<NioSession> ioProcessor;

    public MinaServiceFactory(FactoryManager manager) {
        this.manager = manager;
        this.executor = ThreadUtils.newCachedThreadPool(manager.toString() + "-mina");
        this.ioProcessor = new SimpleIoProcessorPool(NioProcessor.class, this.getNioWorkers());
    }

    public IoConnector createConnector(IoHandler handler) {
        return new MinaConnector(this.manager, handler, this.ioProcessor);
    }

    public IoAcceptor createAcceptor(IoHandler handler) {
        return new MinaAcceptor(this.manager, handler, this.ioProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCloseImmediately() {
        try {
            this.executor.shutdownNow();
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.log.debug("Exception caught while closing executor", (Throwable)e);
        }
        finally {
            super.doCloseImmediately();
        }
    }

    public int getNioWorkers() {
        int nb;
        String nioWorkers = this.manager.getProperties().get("nio-workers");
        if (nioWorkers != null && nioWorkers.length() > 0 && (nb = Integer.parseInt(nioWorkers)) > 0) {
            return nb;
        }
        return FactoryManager.DEFAULT_NIO_WORKERS;
    }
}

