/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.service.guard.impl;

import org.apache.karaf.service.guard.impl.GuardProxyCatalog;
import org.apache.karaf.service.guard.impl.GuardingEventHook;
import org.apache.karaf.service.guard.impl.GuardingFindHook;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.FindHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    GuardingEventHook guardingEventHook;
    GuardingFindHook guardingFindHook;
    GuardProxyCatalog guardProxyCatalog;

    public void start(BundleContext bundleContext) throws Exception {
        String f = System.getProperty("karaf.secured.services");
        if (f == null) {
            this.logger.info("No role-based security for services as its system property is not set: {}", (Object)"karaf.secured.services");
            return;
        }
        Filter securedServicesFilter = bundleContext.createFilter(f);
        this.logger.info("Adding role-based security to services with filter: {}", (Object)f);
        this.guardProxyCatalog = new GuardProxyCatalog(bundleContext);
        this.guardingEventHook = new GuardingEventHook(bundleContext, this.guardProxyCatalog, securedServicesFilter);
        bundleContext.registerService(EventListenerHook.class, (Object)this.guardingEventHook, null);
        this.guardingFindHook = new GuardingFindHook(bundleContext, this.guardProxyCatalog, securedServicesFilter);
        bundleContext.registerService(FindHook.class, (Object)this.guardingFindHook, null);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.guardProxyCatalog != null) {
            this.guardProxyCatalog.close();
        }
    }
}

