/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.internal;

import org.ops4j.pax.logging.FqcnIgnoringPaxLogger;
import org.ops4j.pax.logging.PaxContext;
import org.osgi.framework.Bundle;

public class DefaultServiceLog
extends FqcnIgnoringPaxLogger {
    private static final int TRACE = 0;
    private static final int DEBUG = 1;
    private static final int INFO = 2;
    private static final int WARN = 3;
    private static final int ERROR = 4;
    private static final int FATAL = 5;
    private static final int NONE = 6;
    public static int level;
    private Bundle m_bundle;
    private String m_categoryName;
    private PaxContext m_context = new PaxContext();

    DefaultServiceLog(Bundle bundle, String categoryName) {
        this.m_bundle = bundle;
        this.m_categoryName = categoryName;
    }

    @Override
    public boolean isTraceEnabled() {
        return level <= 0;
    }

    @Override
    public boolean isDebugEnabled() {
        return level <= 1;
    }

    @Override
    public boolean isWarnEnabled() {
        return level <= 3;
    }

    @Override
    public boolean isInfoEnabled() {
        return level <= 2;
    }

    @Override
    public boolean isErrorEnabled() {
        return level <= 4;
    }

    @Override
    public boolean isFatalEnabled() {
        return level <= 5;
    }

    @Override
    public void trace(String message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.output(message, t);
        }
    }

    @Override
    public void debug(String message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.output(message, t);
        }
    }

    @Override
    public void inform(String message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.output(message, t);
        }
    }

    @Override
    public void warn(String message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.output(message, t);
        }
    }

    @Override
    public void error(String message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.output(message, t);
        }
    }

    @Override
    public void fatal(String message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.output(message, t);
        }
    }

    @Override
    public int getLogLevel() {
        return level;
    }

    public static void setLogLevel(String level) {
        DefaultServiceLog.convertLevel(level);
    }

    @Override
    public String getName() {
        return this.m_categoryName;
    }

    private void output(String message, Throwable t) {
        if (this.m_bundle != null) {
            System.out.print(this.m_bundle.getSymbolicName());
        }
        System.out.print("[");
        System.out.print(this.m_categoryName);
        System.out.print("] : ");
        System.out.println(message);
        if (t != null) {
            t.printStackTrace(System.out);
        }
    }

    private static void convertLevel(String levelName) {
        level = "TRACE".equals(levelName) ? 0 : ("DEBUG".equals(levelName) ? 1 : ("INFO".equals(levelName) ? 2 : ("WARN".equals(levelName) ? 3 : ("ERROR".equals(levelName) ? 4 : ("FATAL".equals(levelName) ? 5 : ("NONE".equals(levelName) ? 6 : 1))))));
    }

    @Override
    public PaxContext getPaxContext() {
        return this.m_context;
    }

    static {
        String levelName = System.getProperty("org.ops4j.pax.logging.DefaultServiceLog.level", "DEBUG").trim();
        DefaultServiceLog.convertLevel(levelName);
    }
}

