/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.mbeans.system.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.GregorianCalendar;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.management.mbeans.system.SystemMBean;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemMBeanImpl
extends StandardMBean
implements SystemMBean {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(SystemMBeanImpl.class);
    private BundleContext bundleContext;

    public SystemMBeanImpl() throws NotCompliantMBeanException {
        super(SystemMBean.class);
    }

    public String getName() {
        return this.bundleContext.getProperty("karaf.name");
    }

    public void setName(String name) {
        try {
            String karafBase = this.bundleContext.getProperty("karaf.base");
            File etcDir = new File(karafBase, "etc");
            File syspropsFile = new File(etcDir, "system.properties");
            FileInputStream fis = new FileInputStream(syspropsFile);
            Properties props = new Properties();
            props.load(fis);
            fis.close();
            props.setProperty("karaf.name", name);
            FileOutputStream fos = new FileOutputStream(syspropsFile);
            props.store(fos, "");
            fos.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String getVersion() {
        return System.getProperty("karaf.version");
    }

    public void halt() throws Exception {
        this.halt(null);
    }

    public void halt(String time) throws Exception {
        this.shutdown(this.timeToSleep(time));
    }

    public void reboot() throws Exception {
        this.reboot(null, false);
    }

    public void reboot(String time, boolean cleanup) throws Exception {
        this.reboot(this.timeToSleep(time), cleanup);
    }

    public void setFrameworkDebug(boolean debug) throws Exception {
        Properties properties = new Properties(new File(System.getProperty("karaf.base"), "etc/config.properties"));
        if (debug) {
            properties.put("felix.log.level", "4");
            properties.put("osgi.debug", "etc/equinox-debug.properties");
        } else {
            properties.remove("felix.log.level");
            properties.remove("osgi.debug");
        }
        properties.save();
    }

    public String getFramework() {
        if (this.bundleContext.getBundle(0L).getSymbolicName().contains("felix")) {
            return "felix";
        }
        return "equinox";
    }

    public void setFramework(String framework) throws Exception {
        Properties properties = new Properties(new File(System.getProperty("karaf.base"), "etc/config.properties"));
        if (!framework.equals("felix") || !framework.equals("equinox")) {
            throw new IllegalArgumentException("Framework name is not supported. Only felix or equinox are supported.");
        }
        properties.put("karaf.framework", framework);
        properties.save();
    }

    public void setStartLevel(int startLevel) {
        Bundle b = this.getBundleContext().getBundle(0L);
        FrameworkStartLevel fsl = (FrameworkStartLevel)b.adapt(FrameworkStartLevel.class);
        fsl.setStartLevel(startLevel, null);
    }

    public int getStartLevel() {
        Bundle b = this.getBundleContext().getBundle(0L);
        FrameworkStartLevel fsl = (FrameworkStartLevel)b.adapt(FrameworkStartLevel.class);
        return fsl.getStartLevel();
    }

    public void shutdown() throws Exception {
        this.halt();
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private void shutdown(final long sleep) {
        new Thread(){

            public void run() {
                try {
                    SystemMBeanImpl.this.sleepWithMsg(sleep, "Shutdown in " + sleep / 1000L / 60L + " minute(s)");
                    SystemMBeanImpl.this.getBundleContext().getBundle(0L).stop();
                }
                catch (Exception e) {
                    LOGGER.error("Halt error", (Throwable)e);
                }
            }
        }.start();
    }

    private void reboot(final long sleep, final boolean clean) {
        new Thread(){

            public void run() {
                try {
                    SystemMBeanImpl.this.sleepWithMsg(sleep, "Reboot in " + sleep / 1000L / 60L + " minute(s)");
                    System.setProperty("karaf.restart", "true");
                    System.setProperty("karaf.restart.clean", Boolean.toString(clean));
                    SystemMBeanImpl.this.bundleContext.getBundle(0L).stop();
                }
                catch (Exception e) {
                    LOGGER.error("Reboot error", (Throwable)e);
                }
            }
        }.start();
    }

    private void sleepWithMsg(long sleep, String msg) throws InterruptedException {
        if (sleep > 0L) {
            LOGGER.info(msg);
            System.err.println(msg);
        }
        Thread.sleep(sleep);
    }

    private long timeToSleep(String time) throws Exception {
        long sleep = 0L;
        if (time != null && !time.equals("now")) {
            if (time.startsWith("+")) {
                time = time.substring(1);
                try {
                    sleep = Long.parseLong(time) * 60L * 1000L;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Time " + time + " is not valid");
                }
            } else {
                String[] strings = time.split(":");
                if (strings.length != 2) {
                    throw new IllegalArgumentException("Time " + time + " is not valid");
                }
                GregorianCalendar currentDate = new GregorianCalendar();
                GregorianCalendar shutdownDate = new GregorianCalendar(currentDate.get(1), currentDate.get(2), currentDate.get(5), Integer.parseInt(strings[0]), Integer.parseInt(strings[1]));
                if (shutdownDate.before(currentDate)) {
                    shutdownDate.set(5, shutdownDate.get(5) + 1);
                }
                sleep = shutdownDate.getTimeInMillis() - currentDate.getTimeInMillis();
            }
        }
        return sleep;
    }
}

