/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.io;

import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.client.io.ConnectPromise;
import org.eclipse.jetty.websocket.client.masks.Masker;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.io.AbstractWebSocketConnection;

public class WebSocketClientConnection
extends AbstractWebSocketConnection {
    private final ConnectPromise connectPromise;
    private final Masker masker;
    private final AtomicBoolean opened = new AtomicBoolean(false);

    public WebSocketClientConnection(EndPoint endp, Executor executor, ConnectPromise connectPromise, WebSocketPolicy policy) {
        super(endp, executor, connectPromise.getClient().getScheduler(), policy, connectPromise.getClient().getBufferPool());
        this.connectPromise = connectPromise;
        this.masker = connectPromise.getMasker();
        assert (this.masker != null);
    }

    public InetSocketAddress getLocalAddress() {
        return this.getEndPoint().getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    public void onOpen() {
        super.onOpen();
        boolean beenOpened = this.opened.getAndSet(true);
        if (!beenOpened) {
            this.connectPromise.succeeded();
        }
    }

    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        if (frame instanceof WebSocketFrame) {
            this.masker.setMask((WebSocketFrame)frame);
        }
        super.outgoingFrame(frame, callback, batchMode);
    }

    public void setNextIncomingFrames(IncomingFrames incoming) {
        this.getParser().setIncomingFramesHandler(incoming);
    }
}

