/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFinder {
    private final URL[] urls;
    private final String path;
    private final ClassLoader classLoader;
    private final List<String> resourcesNotLoaded = new ArrayList<String>();

    public ResourceFinder(URL ... urls) {
        this(null, Thread.currentThread().getContextClassLoader(), urls);
    }

    public ResourceFinder(String path) {
        this(path, Thread.currentThread().getContextClassLoader(), null);
    }

    public ResourceFinder(String path, URL ... urls) {
        this(path, Thread.currentThread().getContextClassLoader(), urls);
    }

    public ResourceFinder(String path, ClassLoader classLoader) {
        this(path, classLoader, null);
    }

    public ResourceFinder(String path, ClassLoader classLoader, URL ... urls) {
        if (path == null) {
            path = "";
        } else if (path.length() > 0 && !path.endsWith("/")) {
            path = path + "/";
        }
        this.path = path;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        this.classLoader = classLoader;
        for (int i = 0; urls != null && i < urls.length; ++i) {
            URL url = urls[i];
            if (url == null || "jar".equals(url.getProtocol()) || ResourceFinder.isDirectory(url)) continue;
            try {
                urls[i] = new URL("jar", "", -1, url.toString() + "!/");
                continue;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        this.urls = urls == null || urls.length == 0 ? null : urls;
    }

    private static boolean isDirectory(URL url) {
        String file = url.getFile();
        return file.length() > 0 && file.charAt(file.length() - 1) == '/' || new File(file).isDirectory();
    }

    public List<String> getResourcesNotLoaded() {
        return Collections.unmodifiableList(this.resourcesNotLoaded);
    }

    public URL find(String uri) throws IOException {
        String fullUri = this.path + uri;
        URL resource = this.getResource(fullUri);
        if (resource == null) {
            throw new IOException("Could not find resource '" + this.path + uri + "'");
        }
        return resource;
    }

    public List<URL> findAll(String uri) throws IOException {
        String fullUri = this.path + uri;
        Enumeration<URL> resources = this.getResources(fullUri);
        ArrayList<URL> list = new ArrayList<URL>();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            list.add(url);
        }
        return list;
    }

    public String findString(String uri) throws IOException {
        String fullUri = this.path + uri;
        URL resource = this.getResource(fullUri);
        if (resource == null) {
            throw new IOException("Could not find a resource in : " + fullUri);
        }
        return this.readContents(resource);
    }

    public List<String> findAllStrings(String uri) throws IOException {
        String fulluri = this.path + uri;
        ArrayList<String> strings = new ArrayList<String>();
        Enumeration<URL> resources = this.getResources(fulluri);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            String string = this.readContents(url);
            strings.add(string);
        }
        return strings;
    }

    public List<String> findAvailableStrings(String uri) throws IOException {
        this.resourcesNotLoaded.clear();
        String fulluri = this.path + uri;
        ArrayList<String> strings = new ArrayList<String>();
        Enumeration<URL> resources = this.getResources(fulluri);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                String string = this.readContents(url);
                strings.add(string);
            }
            catch (IOException notAvailable) {
                this.resourcesNotLoaded.add(url.toExternalForm());
            }
        }
        return strings;
    }

    public Map<String, String> mapAllStrings(String uri) throws IOException {
        HashMap<String, String> strings = new HashMap<String, String>();
        Map<String, URL> resourcesMap = this.getResourcesMap(uri);
        for (Map.Entry<String, URL> entry : resourcesMap.entrySet()) {
            String name = entry.getKey();
            URL url = entry.getValue();
            String value = this.readContents(url);
            strings.put(name, value);
        }
        return strings;
    }

    public Map<String, String> mapAvailableStrings(String uri) throws IOException {
        this.resourcesNotLoaded.clear();
        HashMap<String, String> strings = new HashMap<String, String>();
        Map<String, URL> resourcesMap = this.getResourcesMap(uri);
        for (Map.Entry<String, URL> entry : resourcesMap.entrySet()) {
            String name = entry.getKey();
            URL url = entry.getValue();
            try {
                String value = this.readContents(url);
                strings.put(name, value);
            }
            catch (IOException notAvailable) {
                this.resourcesNotLoaded.add(url.toExternalForm());
            }
        }
        return strings;
    }

    public Class<?> findClass(String uri) throws IOException, ClassNotFoundException {
        String className = this.findString(uri);
        return this.classLoader.loadClass(className);
    }

    public List<Class<?>> findAllClasses(String uri) throws IOException, ClassNotFoundException {
        ArrayList classes = new ArrayList();
        List<String> strings = this.findAllStrings(uri);
        for (String className : strings) {
            Class<?> clazz = this.classLoader.loadClass(className);
            classes.add(clazz);
        }
        return classes;
    }

    public List<Class<?>> findAvailableClasses(String uri) throws IOException {
        this.resourcesNotLoaded.clear();
        ArrayList classes = new ArrayList();
        List<String> strings = this.findAvailableStrings(uri);
        for (String className : strings) {
            try {
                Class<?> clazz = this.classLoader.loadClass(className);
                classes.add(clazz);
            }
            catch (Exception notAvailable) {
                this.resourcesNotLoaded.add(className);
            }
        }
        return classes;
    }

    public Map<String, Class<?>> mapAllClasses(String uri) throws IOException, ClassNotFoundException {
        HashMap classes = new HashMap();
        Map<String, String> map = this.mapAllStrings(uri);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String className = entry.getValue();
            Class<?> clazz = this.classLoader.loadClass(className);
            classes.put(string, clazz);
        }
        return classes;
    }

    public Map<String, Class<?>> mapAvailableClasses(String uri) throws IOException {
        this.resourcesNotLoaded.clear();
        HashMap classes = new HashMap();
        Map<String, String> map = this.mapAvailableStrings(uri);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String className = entry.getValue();
            try {
                Class<?> clazz = this.classLoader.loadClass(className);
                classes.put(string, clazz);
            }
            catch (Exception notAvailable) {
                this.resourcesNotLoaded.add(className);
            }
        }
        return classes;
    }

    public Class<?> findImplementation(Class<?> interfase) throws IOException, ClassNotFoundException {
        String className = this.findString(interfase.getName());
        Class<?> impl = this.classLoader.loadClass(className);
        if (!interfase.isAssignableFrom(impl)) {
            throw new ClassCastException("Class not of type: " + interfase.getName());
        }
        return impl;
    }

    public <T> List<Class<? extends T>> findAllImplementations(Class<T> interfase) throws IOException, ClassNotFoundException {
        ArrayList<Class<T>> implementations = new ArrayList<Class<T>>();
        List<String> strings = this.findAllStrings(interfase.getName());
        for (String className : strings) {
            Class<T> impl = this.classLoader.loadClass(className).asSubclass(interfase);
            implementations.add(impl);
        }
        return implementations;
    }

    public <T> List<Class<? extends T>> findAvailableImplementations(Class<T> interfase) throws IOException {
        this.resourcesNotLoaded.clear();
        ArrayList<Class<T>> implementations = new ArrayList<Class<T>>();
        List<String> strings = this.findAvailableStrings(interfase.getName());
        for (String className : strings) {
            try {
                Class<?> impl = this.classLoader.loadClass(className);
                if (interfase.isAssignableFrom(impl)) {
                    implementations.add(impl.asSubclass(interfase));
                    continue;
                }
                this.resourcesNotLoaded.add(className);
            }
            catch (Exception notAvailable) {
                this.resourcesNotLoaded.add(className);
            }
        }
        return implementations;
    }

    public <T> Map<String, Class<? extends T>> mapAllImplementations(Class<T> interfase) throws IOException, ClassNotFoundException {
        HashMap<String, Class<T>> implementations = new HashMap<String, Class<T>>();
        Map<String, String> map = this.mapAllStrings(interfase.getName());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String className = entry.getValue();
            Class<T> impl = this.classLoader.loadClass(className).asSubclass(interfase);
            implementations.put(string, impl);
        }
        return implementations;
    }

    public <T> Map<String, Class<? extends T>> mapAvailableImplementations(Class<T> interfase) throws IOException {
        this.resourcesNotLoaded.clear();
        HashMap<String, Class<T>> implementations = new HashMap<String, Class<T>>();
        Map<String, String> map = this.mapAvailableStrings(interfase.getName());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String className = entry.getValue();
            try {
                Class<?> impl = this.classLoader.loadClass(className);
                if (interfase.isAssignableFrom(impl)) {
                    implementations.put(string, impl.asSubclass(interfase));
                    continue;
                }
                this.resourcesNotLoaded.add(className);
            }
            catch (Exception notAvailable) {
                this.resourcesNotLoaded.add(className);
            }
        }
        return implementations;
    }

    public Properties findProperties(String uri) throws IOException {
        String fulluri = this.path + uri;
        URL resource = this.getResource(fulluri);
        if (resource == null) {
            throw new IOException("Could not find resource: " + fulluri);
        }
        return this.loadProperties(resource);
    }

    public List<Properties> findAllProperties(String uri) throws IOException {
        String fulluri = this.path + uri;
        ArrayList<Properties> properties = new ArrayList<Properties>();
        Enumeration<URL> resources = this.getResources(fulluri);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            Properties props = this.loadProperties(url);
            properties.add(props);
        }
        return properties;
    }

    public List<Properties> findAvailableProperties(String uri) throws IOException {
        this.resourcesNotLoaded.clear();
        String fulluri = this.path + uri;
        ArrayList<Properties> properties = new ArrayList<Properties>();
        Enumeration<URL> resources = this.getResources(fulluri);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                Properties props = this.loadProperties(url);
                properties.add(props);
            }
            catch (Exception notAvailable) {
                this.resourcesNotLoaded.add(url.toExternalForm());
            }
        }
        return properties;
    }

    public Map<String, Properties> mapAllProperties(String uri) throws IOException {
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        Map<String, URL> map = this.getResourcesMap(uri);
        for (Map.Entry<String, URL> entry : map.entrySet()) {
            String string = entry.getKey();
            URL url = entry.getValue();
            Properties properties = this.loadProperties(url);
            propertiesMap.put(string, properties);
        }
        return propertiesMap;
    }

    public Map<String, Properties> mapAvailableProperties(String uri) throws IOException {
        this.resourcesNotLoaded.clear();
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        Map<String, URL> map = this.getResourcesMap(uri);
        for (Map.Entry<String, URL> entry : map.entrySet()) {
            String string = entry.getKey();
            URL url = entry.getValue();
            try {
                Properties properties = this.loadProperties(url);
                propertiesMap.put(string, properties);
            }
            catch (Exception notAvailable) {
                this.resourcesNotLoaded.add(url.toExternalForm());
            }
        }
        return propertiesMap;
    }

    public Map<String, URL> getResourcesMap(String uri) throws IOException {
        String basePath = this.path + uri;
        HashMap<String, URL> resources = new HashMap<String, URL>();
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        Enumeration<URL> urls = this.getResources(basePath);
        while (urls.hasMoreElements()) {
            URL location = urls.nextElement();
            try {
                if (location.getProtocol().equals("jar")) {
                    ResourceFinder.readJarEntries(location, basePath, resources);
                    continue;
                }
                if (!location.getProtocol().equals("file")) continue;
                ResourceFinder.readDirectoryEntries(location, resources);
            }
            catch (Exception e) {}
        }
        return resources;
    }

    private static void readDirectoryEntries(URL location, Map<String, URL> resources) throws MalformedURLException {
        File dir = new File(ResourceFinder.decode(location.getPath()));
        if (dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                if (file.isDirectory()) continue;
                String name = file.getName();
                URL url = file.toURI().toURL();
                resources.put(name, url);
            }
        }
    }

    private static void readJarEntries(URL location, String basePath, Map<String, URL> resources) throws IOException {
        JarURLConnection conn = (JarURLConnection)location.openConnection();
        JarFile jarfile = null;
        jarfile = conn.getJarFile();
        Enumeration<JarEntry> entries = jarfile.entries();
        while (entries != null && entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (entry.isDirectory() || !name.startsWith(basePath) || name.length() == basePath.length() || (name = name.substring(basePath.length())).contains("/")) continue;
            URL resource = new URL(location, name);
            resources.put(name, resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(URL resource) throws IOException {
        InputStream in = resource.openStream();
        BufferedInputStream reader = null;
        try {
            reader = new BufferedInputStream(in);
            Properties properties = new Properties();
            properties.load(reader);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            try {
                in.close();
                reader.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readContents(URL resource) throws IOException {
        InputStream in = resource.openStream();
        BufferedInputStream reader = null;
        StringBuffer sb = new StringBuffer();
        try {
            reader = new BufferedInputStream(in);
            int b = reader.read();
            while (b != -1) {
                sb.append((char)b);
                b = reader.read();
            }
            String string = sb.toString().trim();
            return string;
        }
        finally {
            try {
                in.close();
                reader.close();
            }
            catch (Exception e) {}
        }
    }

    public URL getResource(String fullUri) {
        if (this.urls == null) {
            return this.classLoader.getResource(fullUri);
        }
        return this.findResource(fullUri, this.urls);
    }

    private Enumeration<URL> getResources(String fulluri) throws IOException {
        if (this.urls == null) {
            return this.classLoader.getResources(fulluri);
        }
        Vector<URL> resources = new Vector<URL>();
        for (URL url : this.urls) {
            URL resource = this.findResource(fulluri, url);
            if (resource == null) continue;
            resources.add(resource);
        }
        return resources.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private URL findResource(String resourceName, URL ... search) {
        for (int i = 0; i < search.length; ++i) {
            URL currentUrl = search[i];
            if (currentUrl == null) continue;
            try {
                String protocol = currentUrl.getProtocol();
                if (protocol.equals("jar")) {
                    JarFile jarFile;
                    JarURLConnection juc;
                    URL jarURL = ((JarURLConnection)currentUrl.openConnection()).getJarFileURL();
                    try {
                        juc = (JarURLConnection)new URL("jar", "", jarURL.toExternalForm() + "!/").openConnection();
                        jarFile = juc.getJarFile();
                    }
                    catch (IOException e) {
                        search[i] = null;
                        throw e;
                    }
                    try {
                        Object file;
                        String entryName;
                        juc = (JarURLConnection)new URL("jar", "", jarURL.toExternalForm() + "!/").openConnection();
                        jarFile = juc.getJarFile();
                        if (currentUrl.getFile().endsWith("!/")) {
                            entryName = resourceName;
                        } else {
                            file = currentUrl.getFile();
                            int sepIdx = ((String)file).lastIndexOf("!/");
                            if (sepIdx == -1) {
                                search[i] = null;
                                continue;
                            }
                            StringBuffer sb = new StringBuffer(((String)file).length() - (sepIdx += 2) + resourceName.length());
                            sb.append(((String)file).substring(sepIdx));
                            sb.append(resourceName);
                            entryName = sb.toString();
                        }
                        if (entryName.equals("META-INF/") && jarFile.getEntry("META-INF/MANIFEST.MF") != null) {
                            file = this.targetURL(currentUrl, "META-INF/MANIFEST.MF");
                            return file;
                        }
                        if (jarFile.getEntry(entryName) == null) continue;
                        file = this.targetURL(currentUrl, resourceName);
                        return file;
                    }
                    finally {
                        if (!juc.getUseCaches()) {
                            try {
                                jarFile.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                }
                if (protocol.equals("file")) {
                    String baseFile = currentUrl.getFile();
                    String host = currentUrl.getHost();
                    int hostLength = 0;
                    if (host != null) {
                        hostLength = host.length();
                    }
                    StringBuffer buf = new StringBuffer(2 + hostLength + baseFile.length() + resourceName.length());
                    if (hostLength > 0) {
                        buf.append("//").append(host);
                    }
                    buf.append(baseFile);
                    if (!baseFile.endsWith("/")) {
                        buf.append("/");
                    }
                    String fixedResName = resourceName;
                    while (fixedResName.startsWith("/") || fixedResName.startsWith("\\")) {
                        fixedResName = fixedResName.substring(1);
                    }
                    buf.append(fixedResName);
                    String filename = buf.toString();
                    File file = new File(filename);
                    File file2 = new File(ResourceFinder.decode(filename));
                    if (!file.exists() && !file2.exists()) continue;
                    return this.targetURL(currentUrl, fixedResName);
                }
                URL resourceURL = this.targetURL(currentUrl, resourceName);
                URLConnection urlConnection = resourceURL.openConnection();
                try {
                    urlConnection.getInputStream().close();
                }
                catch (SecurityException e) {
                    return null;
                }
                if (!resourceURL.getProtocol().equals("http")) {
                    return resourceURL;
                }
                int code = ((HttpURLConnection)urlConnection).getResponseCode();
                if (code < 200 || code >= 300) continue;
                return resourceURL;
            }
            catch (MalformedURLException e) {
                continue;
            }
            catch (IOException e) {
                continue;
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        return null;
    }

    private URL targetURL(URL base, String name) throws MalformedURLException {
        String baseFile = base.getFile();
        StringBuffer sb = new StringBuffer(baseFile.length() + name.length());
        sb.append(baseFile);
        if (!baseFile.endsWith("/")) {
            sb.append("/");
        }
        sb.append(name);
        return new URL(base.getProtocol(), base.getHost(), base.getPort(), sb.toString(), null);
    }

    public static String decode(String fileName) {
        if (fileName.indexOf(37) == -1) {
            return fileName;
        }
        StringBuilder result = new StringBuilder(fileName.length());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < fileName.length()) {
            char c = fileName.charAt(i);
            if (c == '%') {
                out.reset();
                do {
                    if (i + 2 >= fileName.length()) {
                        throw new IllegalArgumentException("Incomplete % sequence at: " + i);
                    }
                    int d1 = Character.digit(fileName.charAt(i + 1), 16);
                    int d2 = Character.digit(fileName.charAt(i + 2), 16);
                    if (d1 == -1 || d2 == -1) {
                        throw new IllegalArgumentException("Invalid % sequence (" + fileName.substring(i, i + 3) + ") at: " + String.valueOf(i));
                    }
                    out.write((byte)((d1 << 4) + d2));
                } while ((i += 3) < fileName.length() && fileName.charAt(i) == '%');
                result.append(out.toString());
                continue;
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }
}

