/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.element.FilterWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.util.ServicePropertiesUtils;
import org.ops4j.pax.web.extender.whiteboard.runtime.DefaultFilterMapping;
import org.ops4j.pax.web.service.WebContainerConstants;
import org.ops4j.pax.web.utils.FilterAnnotationScanner;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterTracker
extends AbstractTracker<Filter, FilterWebElement> {
    private static final Logger LOG = LoggerFactory.getLogger(FilterTracker.class);

    private FilterTracker(ExtenderContext extenderContext, BundleContext bundleContext) {
        super(extenderContext, bundleContext);
    }

    public static ServiceTracker<Filter, FilterWebElement> createTracker(ExtenderContext extenderContext, BundleContext bundleContext) {
        return new FilterTracker(extenderContext, bundleContext).create(Filter.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    FilterWebElement createWebElement(ServiceReference<Filter> serviceReference, Filter published) {
        Integer serviceRank;
        void var15_24;
        String[] urlPatternsProp = serviceReference.getProperty("urlPatterns");
        if (urlPatternsProp == null) {
            urlPatternsProp = serviceReference.getProperty("osgi.http.whiteboard.filter.pattern");
        } else {
            String[] whiteBoardProp = ServicePropertiesUtils.getArrayOfStringProperty(serviceReference, "osgi.http.whiteboard.filter.pattern");
            if (whiteBoardProp != null) {
                urlPatternsProp = ServicePropertiesUtils.mergePropertyListOfStringsToArrayOfStrings(urlPatternsProp, Arrays.asList(whiteBoardProp));
            }
        }
        String[] regexUrlProps = ServicePropertiesUtils.getArrayOfStringProperty(serviceReference, "osgi.http.whiteboard.filter.regex");
        if (regexUrlProps != null) {
            urlPatternsProp = ServicePropertiesUtils.mergePropertyListOfStringsToArrayOfStrings(urlPatternsProp, Arrays.asList(regexUrlProps));
        }
        String[] urlPatterns = null;
        FilterAnnotationScanner annotationScan = new FilterAnnotationScanner(published.getClass());
        if (annotationScan.scanned.booleanValue()) {
            if (urlPatternsProp == null) {
                urlPatternsProp = annotationScan.urlPatterns;
            } else {
                HashSet<String> patterns = new HashSet<String>();
                patterns.addAll(Arrays.asList(annotationScan.urlPatterns));
                if (urlPatternsProp instanceof String && ((String)urlPatternsProp).trim().length() != 0) {
                    patterns.add((String)urlPatternsProp);
                } else if (urlPatternsProp instanceof String[]) {
                    patterns.addAll(Arrays.asList(urlPatternsProp));
                }
                urlPatternsProp = patterns.toArray(new String[patterns.size()]);
            }
        }
        if (urlPatternsProp != null) {
            if (urlPatternsProp instanceof String) {
                urlPatterns = new String[]{(String)urlPatternsProp};
            } else if (urlPatternsProp instanceof String[]) {
                urlPatterns = urlPatternsProp;
            }
        }
        String[] servletNamesProp = serviceReference.getProperty("servletNames");
        if (annotationScan.scanned.booleanValue()) {
            if (servletNamesProp == null) {
                servletNamesProp = annotationScan.servletNames;
            } else {
                HashSet<String> patterns = new HashSet<String>();
                patterns.addAll(Arrays.asList(annotationScan.servletNames));
                if (servletNamesProp instanceof String && ((String)servletNamesProp).trim().length() != 0) {
                    patterns.add((String)servletNamesProp);
                } else if (servletNamesProp instanceof String[]) {
                    patterns.addAll(Arrays.asList(servletNamesProp));
                }
                servletNamesProp = patterns.toArray(new String[patterns.size()]);
            }
        }
        String[] servletNames = null;
        if (servletNamesProp != null) {
            if (servletNamesProp instanceof String) {
                servletNames = new String[]{(String)servletNamesProp};
            } else if (servletNamesProp instanceof String[]) {
                servletNames = servletNamesProp;
            }
        }
        String httpContextId = ServicePropertiesUtils.extractHttpContextId(serviceReference);
        String[] initParamKeys = serviceReference.getPropertyKeys();
        HashMap<String, String> initParams = new HashMap<String, String>();
        for (String string : initParamKeys) {
            try {
                String value = serviceReference.getProperty(string) == null ? "" : serviceReference.getProperty(string).toString();
                initParams.put(string, value);
            }
            catch (Exception value) {
                // empty catch block
            }
        }
        if (annotationScan.scanned.booleanValue()) {
            for (String string : annotationScan.webInitParams) {
                initParams.put(string.name(), string.value());
            }
        }
        Boolean asyncSupported = Boolean.FALSE;
        Object value = serviceReference.getProperty("osgi.http.whiteboard.filter.asyncSupported");
        asyncSupported = value instanceof Boolean ? (Boolean)value : ServicePropertiesUtils.getBooleanProperty(serviceReference, "osgi.http.whiteboard.filter.asyncSupported");
        if (annotationScan.scanned.booleanValue()) {
            asyncSupported = annotationScan.asyncSupported;
        }
        String[] dispatcherTypeProps = ServicePropertiesUtils.getArrayOfStringProperty(serviceReference, "osgi.http.whiteboard.filter.dispatcher");
        Object var15_20 = null;
        if (annotationScan.scanned.booleanValue()) {
            if (dispatcherTypeProps == null) {
                DispatcherType[] dispatcherTypeArray = annotationScan.dispatcherTypes;
            } else {
                DispatcherType[] dispatcherTypeArray = annotationScan.dispatcherTypes;
                ArrayList<DispatcherType> dispatcherTypeList = new ArrayList<DispatcherType>(Arrays.asList(dispatcherTypeArray));
                for (String dispatcherTypeProp : dispatcherTypeProps) {
                    dispatcherTypeList.add(DispatcherType.valueOf((String)dispatcherTypeProp));
                }
                DispatcherType[] dispatcherTypeArray2 = dispatcherTypeList.toArray(new DispatcherType[dispatcherTypeList.size()]);
            }
        }
        String dispatcherInitString = null;
        if (var15_24 != null) {
            StringBuffer buff = new StringBuffer();
            for (void dispatcherType : var15_24) {
                buff = buff.append(dispatcherType.toString()).append(",");
            }
            dispatcherInitString = buff.toString();
            dispatcherInitString = dispatcherInitString.substring(dispatcherInitString.length() - 1);
        }
        if (dispatcherInitString != null) {
            initParams.put(WebContainerConstants.FILTER_MAPPING_DISPATCHER, dispatcherInitString);
        }
        if ((serviceRank = ServicePropertiesUtils.getIntegerProperty(serviceReference, "service.ranking")) != null) {
            initParams.put("filterRank", serviceRank.toString());
        }
        DefaultFilterMapping mapping = new DefaultFilterMapping();
        mapping.setFilter(published);
        mapping.setAsyncSupported(asyncSupported);
        mapping.setHttpContextId(httpContextId);
        mapping.setUrlPatterns(urlPatterns);
        mapping.setServletNames(servletNames);
        mapping.setInitParams(initParams);
        mapping.setDispatcherType((DispatcherType[])var15_24);
        mapping.setName(ServicePropertiesUtils.getStringProperty(serviceReference, "osgi.http.whiteboard.filter.name"));
        return new FilterWebElement<Filter>(serviceReference, mapping);
    }
}

