/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.command.completer;

import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.scr.command.action.ScrActionSupport;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.osgi.framework.Bundle;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScrCompleterSupport
implements Completer {
    protected final transient Logger logger = LoggerFactory.getLogger(ScrCompleterSupport.class);
    @Reference
    private ServiceComponentRuntime serviceComponentRuntime;

    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        try {
            ArrayList configs = new ArrayList();
            for (ComponentDescriptionDTO component : this.serviceComponentRuntime.getComponentDescriptionDTOs(new Bundle[0])) {
                configs.addAll(this.serviceComponentRuntime.getComponentConfigurationDTOs(component));
            }
            for (ComponentDescriptionDTO component : configs) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Component Name to work on: " + component.description.name);
                }
                if (ScrActionSupport.showHiddenComponent(commandLine)) {
                    if (!this.availableComponent((ComponentConfigurationDTO)component)) continue;
                    delegate.getStrings().add(component.description.name);
                    continue;
                }
                if (ScrActionSupport.isHiddenComponent((ComponentConfigurationDTO)component) || !this.availableComponent((ComponentConfigurationDTO)component)) continue;
                delegate.getStrings().add(component.description.name);
            }
        }
        catch (Exception e) {
            this.logger.warn("Exception completing the command request: " + e.getLocalizedMessage());
        }
        return delegate.complete(session, commandLine, candidates);
    }

    public abstract boolean availableComponent(ComponentConfigurationDTO var1) throws Exception;

    public ServiceComponentRuntime getServiceComponentRuntime() {
        return this.serviceComponentRuntime;
    }

    public void setSServiceComponentRuntime(ServiceComponentRuntime serviceComponentRuntime) {
        this.serviceComponentRuntime = serviceComponentRuntime;
    }
}

