/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.maven.wagon.providers.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import shaded.org.apache.commons.lang.StringUtils;
import shaded.org.apache.maven.wagon.ConnectionException;
import shaded.org.apache.maven.wagon.InputData;
import shaded.org.apache.maven.wagon.LazyFileOutputStream;
import shaded.org.apache.maven.wagon.OutputData;
import shaded.org.apache.maven.wagon.ResourceDoesNotExistException;
import shaded.org.apache.maven.wagon.StreamWagon;
import shaded.org.apache.maven.wagon.TransferFailedException;
import shaded.org.apache.maven.wagon.authorization.AuthorizationException;
import shaded.org.apache.maven.wagon.resource.Resource;
import shaded.org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileWagon
extends StreamWagon {
    @Override
    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException {
        if (this.getRepository().getBasedir() == null) {
            throw new TransferFailedException("Unable to operate with a null basedir.");
        }
        Resource resource = inputData.getResource();
        File file = new File(this.getRepository().getBasedir(), resource.getName());
        if (!file.exists()) {
            throw new ResourceDoesNotExistException("File: " + file + " does not exist");
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            inputData.setInputStream(in);
            resource.setContentLength(file.length());
            resource.setLastModified(file.lastModified());
        }
        catch (FileNotFoundException e) {
            throw new TransferFailedException("Could not read from file: " + file.getAbsolutePath(), e);
        }
    }

    @Override
    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        if (this.getRepository().getBasedir() == null) {
            throw new TransferFailedException("Unable to operate with a null basedir.");
        }
        Resource resource = outputData.getResource();
        File file = new File(this.getRepository().getBasedir(), resource.getName());
        this.createParentDirectories(file);
        BufferedOutputStream outputStream = new BufferedOutputStream(new LazyFileOutputStream(file));
        outputData.setOutputStream(outputStream);
    }

    @Override
    protected void openConnectionInternal() throws ConnectionException {
        if (this.getRepository() == null) {
            throw new ConnectionException("Unable to operate with a null repository.");
        }
        if (this.getRepository().getBasedir() == null) {
            this.fireSessionDebug("Using a null basedir.");
            return;
        }
        File basedir = new File(this.getRepository().getBasedir());
        if (!basedir.exists() && !basedir.mkdirs()) {
            throw new ConnectionException("Repository path " + basedir + " does not exist," + " and cannot be created.");
        }
        if (!basedir.canRead()) {
            throw new ConnectionException("Repository path " + basedir + " cannot be read");
        }
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public boolean supportsDirectoryCopy() {
        return true;
    }

    @Override
    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (this.getRepository().getBasedir() == null) {
            throw new TransferFailedException("Unable to putDirectory() with a null basedir.");
        }
        File path = this.resolveDestinationPath(destinationDirectory);
        try {
            File realFile = path.getCanonicalFile();
            realFile.mkdirs();
        }
        catch (IOException e) {
            path.mkdirs();
        }
        if (!path.exists() || !path.isDirectory()) {
            String emsg = "Could not make directory '" + path.getAbsolutePath() + "'.";
            File basedir = new File(this.getRepository().getBasedir());
            if (!basedir.canWrite()) {
                emsg = emsg + "  The base directory " + basedir + " is read-only.";
            }
            throw new TransferFailedException(emsg);
        }
        try {
            FileUtils.copyDirectoryStructure(sourceDirectory, path);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error copying directory structure", e);
        }
    }

    private File resolveDestinationPath(String destinationPath) {
        String basedir = this.getRepository().getBasedir();
        File path = (destinationPath = StringUtils.replace(destinationPath, "\\", "/")).equals(".") ? new File(basedir) : new File(basedir, destinationPath);
        return path;
    }

    @Override
    public List<String> getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (this.getRepository().getBasedir() == null) {
            throw new TransferFailedException("Unable to getFileList() with a null basedir.");
        }
        File path = this.resolveDestinationPath(destinationDirectory);
        if (!path.exists()) {
            throw new ResourceDoesNotExistException("Directory does not exist: " + destinationDirectory);
        }
        if (!path.isDirectory()) {
            throw new ResourceDoesNotExistException("Path is not a directory: " + destinationDirectory);
        }
        File[] files = path.listFiles();
        ArrayList<String> list = new ArrayList<String>(files.length);
        for (File file : files) {
            String name = file.getName();
            if (file.isDirectory() && !name.endsWith("/")) {
                name = name + "/";
            }
            list.add(name);
        }
        return list;
    }

    @Override
    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        if (this.getRepository().getBasedir() == null) {
            throw new TransferFailedException("Unable to getFileList() with a null basedir.");
        }
        File file = this.resolveDestinationPath(resourceName);
        if (resourceName.endsWith("/")) {
            return file.isDirectory();
        }
        return file.exists();
    }
}

