/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.HashedSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LateInvalidatingHashSessionManager
extends HashSessionManager {
    private static final Logger LOG = LoggerFactory.getLogger(LateInvalidatingHashSessionManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scavenge() {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldClazzLoader = thread.getContextClassLoader();
        try {
            if (this._loader != null) {
                thread.setContextClassLoader(this._loader);
            }
            Class<LateInvalidatingHashSessionManager> clazz = LateInvalidatingHashSessionManager.class;
            synchronized (LateInvalidatingHashSessionManager.class) {
                long now = System.currentTimeMillis();
                for (HashedSession session : this._sessions.values()) {
                    long idleTime;
                    if (this.isTimeoutCandidate((AbstractSession)session, idleTime = (long)(session.getMaxInactiveInterval() * 1000), now)) {
                        if (this._sessionIdManager instanceof HashSessionIdManager) {
                            Collection<AbstractSession> sessionsWithId = this.getSessionsWithId(session.getId());
                            if (sessionsWithId == null || sessionsWithId.size() < 1) {
                                throw new IllegalStateException();
                            }
                            if (this.areAllTimeoutCandidates(sessionsWithId, idleTime, now)) {
                                LOG.info("Timing out for " + sessionsWithId.size() + " session(s) with id " + session.getId());
                                for (AbstractSession sessionToTimeout : sessionsWithId) {
                                    this.sessionTimeout(sessionToTimeout);
                                }
                                continue;
                            }
                            LOG.info("Extending timeout for " + sessionsWithId.size() + " session(s) with id " + session.getId());
                            this.setLatestLastAccessed(sessionsWithId);
                            continue;
                        }
                        this.sessionTimeout((AbstractSession)session);
                        continue;
                    }
                    if (this.getIdleSavePeriodMs() <= 0L || session.getAccessed() + this.getIdleSavePeriodMs() >= now) continue;
                    session.idle();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            LOG.warn("Problem scavenging sessions", t);
        }
        finally {
            thread.setContextClassLoader(oldClazzLoader);
        }
        {
            return;
        }
    }

    private Collection<AbstractSession> getSessionsWithId(String id) {
        Collection sessions = ((HashSessionIdManager)this._sessionIdManager).getSession(id);
        if (sessions == null) {
            return null;
        }
        if (sessions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AbstractSession> abstractSessions = new ArrayList<AbstractSession>(sessions.size());
        for (HttpSession session : sessions) {
            abstractSessions.add((AbstractSession)session);
        }
        return abstractSessions;
    }

    private boolean areAllTimeoutCandidates(Collection<AbstractSession> sessions, long idleTime, long now) {
        for (AbstractSession session : sessions) {
            if (this.isTimeoutCandidate(session, idleTime, now)) continue;
            return false;
        }
        return true;
    }

    private boolean isTimeoutCandidate(AbstractSession session, long idleTime, long now) {
        return idleTime > 0L && session.getAccessed() + idleTime < now;
    }

    private long getIdleSavePeriodMs() {
        try {
            Field f = HashSessionManager.class.getDeclaredField("_idleSavePeriodMs");
            f.setAccessible(true);
            return (Long)f.get((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing invisible HashSessionManager field via reflection", e);
        }
    }

    private void sessionTimeout(AbstractSession session) {
        try {
            Method m = AbstractSession.class.getDeclaredMethod("timeout", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)session, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing invisible AbstractSession method via reflection", e);
        }
    }

    private void setLatestLastAccessed(Collection<AbstractSession> sessionsWithId) {
        long latestAccessed = 0L;
        long latestLastAccessed = 0L;
        for (AbstractSession otherSession : sessionsWithId) {
            latestAccessed = Math.max(latestAccessed, otherSession.getAccessed());
            latestLastAccessed = Math.max(latestLastAccessed, otherSession.getLastAccessedTime());
        }
        for (AbstractSession session : sessionsWithId) {
            if (session.getAccessed() < latestAccessed) {
                try {
                    Field accessedField = AbstractSession.class.getDeclaredField("_accessed");
                    accessedField.setAccessible(true);
                    accessedField.set(session, latestAccessed);
                }
                catch (Exception e) {
                    LOG.warn("Error setting _accessed for session " + session, (Throwable)e);
                }
            }
            if (session.getLastAccessedTime() >= latestLastAccessed) continue;
            try {
                Field lastAccessedField = AbstractSession.class.getDeclaredField("_lastAccessed");
                lastAccessedField.setAccessible(true);
                lastAccessedField.set(session, latestLastAccessed);
            }
            catch (Exception e) {
                LOG.warn("Error setting _lastAccessed for session " + session, (Throwable)e);
            }
        }
    }

    protected void invalidateSessions() throws Exception {
        ArrayList sessions = new ArrayList(this._sessions.values());
        int loop = 100;
        while (sessions.size() > 0 && loop-- > 0) {
            if (this.isStopping()) {
                File storeDir = this.getStoreDir(this);
                for (HashedSession session : sessions) {
                    if (storeDir != null && storeDir.exists() && storeDir.canWrite()) {
                        this.sessionSave(session, false);
                    }
                    this.removeSession((AbstractSession)session, false);
                }
            } else {
                for (HashedSession session : sessions) {
                    session.invalidate();
                }
            }
            sessions = new ArrayList(this._sessions.values());
        }
    }

    private File getStoreDir(HashSessionManager manager) {
        try {
            Field f = HashSessionManager.class.getDeclaredField("_storeDir");
            f.setAccessible(true);
            return (File)f.get((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing invisible HashSessionManager field via reflection", e);
        }
    }

    private void sessionSave(HashedSession session, boolean reactivate) {
        try {
            Method m = HashedSession.class.getDeclaredMethod("save", Boolean.TYPE);
            m.setAccessible(true);
            m.invoke((Object)session, reactivate);
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing invisible HashedSession method via reflection", e);
        }
    }
}

