/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.karaf.jaas.boot.ProxyLoginModule;
import org.apache.karaf.jaas.config.JaasRealm;
import org.osgi.framework.BundleContext;

public class KarafRealm
implements JaasRealm {
    private static final String KARAF_ETC = System.getProperty("karaf.etc");
    private static final String REALM = "karaf";
    private static final String PROPERTIES_MODULE = "org.apache.karaf.jaas.modules.properties.PropertiesLoginModule";
    private static final String PUBLIC_KEY_MODULE = "org.apache.karaf.jaas.modules.publickey.PublickeyLoginModule";
    private static final String FILE_AUDIT_MODULE = "org.apache.karaf.jaas.modules.audit.FileAuditLoginModule";
    private static final String LOG_AUDIT_MODULE = "org.apache.karaf.jaas.modules.audit.LogAuditLoginModule";
    private static final String EVENTADMIN_AUDIT_MODULE = "org.apache.karaf.jaas.modules.audit.EventAdminAuditLoginModule";
    private static final String MODULE = "org.apache.karaf.jaas.module";
    private final BundleContext bundleContext;
    private volatile Map<String, Object> properties;

    public KarafRealm(BundleContext bundleContext, Map<String, Object> properties) {
        this.bundleContext = bundleContext;
        this.updated(properties);
    }

    public void updated(Map<String, Object> properties) {
        this.properties = properties;
    }

    public String getName() {
        return REALM;
    }

    public int getRank() {
        return 0;
    }

    public AppConfigurationEntry[] getEntries() {
        HashMap<String, Object> propertiesOptions = new HashMap<String, Object>();
        propertiesOptions.put(BundleContext.class.getName(), this.bundleContext);
        propertiesOptions.put(MODULE, PROPERTIES_MODULE);
        propertiesOptions.put("org.apache.karaf.jaas.bundle", Long.toString(this.bundleContext.getBundle().getBundleId()));
        propertiesOptions.put("users", KARAF_ETC + File.separatorChar + "users.properties");
        propertiesOptions.put("detailed.login.exception", this.properties.get("detailed.login.exception"));
        propertiesOptions.put("encryption.name", this.properties.get("encryption.name"));
        propertiesOptions.put("encryption.enabled", this.properties.get("encryption.enabled"));
        propertiesOptions.put("encryption.prefix", this.properties.get("encryption.prefix"));
        propertiesOptions.put("encryption.suffix", this.properties.get("encryption.suffix"));
        propertiesOptions.put("encryption.algorithm", this.properties.get("encryption.algorithm"));
        propertiesOptions.put("encryption.encoding", this.properties.get("encryption.encoding"));
        HashMap<String, Object> publicKeyOptions = new HashMap<String, Object>();
        publicKeyOptions.put(BundleContext.class.getName(), this.bundleContext);
        publicKeyOptions.put(MODULE, PUBLIC_KEY_MODULE);
        publicKeyOptions.put("org.apache.karaf.jaas.bundle", Long.toString(this.bundleContext.getBundle().getBundleId()));
        publicKeyOptions.put("users", KARAF_ETC + File.separatorChar + "keys.properties");
        publicKeyOptions.put("detailed.login.exception", this.properties.get("detailed.login.exception"));
        HashMap<String, Object> fileOptions = new HashMap<String, Object>();
        fileOptions.put(BundleContext.class.getName(), this.bundleContext);
        fileOptions.put(MODULE, FILE_AUDIT_MODULE);
        fileOptions.put("org.apache.karaf.jaas.bundle", Long.toString(this.bundleContext.getBundle().getBundleId()));
        fileOptions.put("enabled", this.properties.get("audit.file.enabled"));
        fileOptions.put("file", this.properties.get("audit.file.file"));
        HashMap<String, Object> logOptions = new HashMap<String, Object>();
        logOptions.put(BundleContext.class.getName(), this.bundleContext);
        logOptions.put(MODULE, LOG_AUDIT_MODULE);
        logOptions.put("org.apache.karaf.jaas.bundle", Long.toString(this.bundleContext.getBundle().getBundleId()));
        logOptions.put("enabled", this.properties.get("audit.log.enabled"));
        logOptions.put("logger", this.properties.get("audit.log.logger"));
        logOptions.put("level", this.properties.get("audit.log.level"));
        HashMap<String, Object> eventadminOptions = new HashMap<String, Object>();
        eventadminOptions.putAll(this.properties);
        eventadminOptions.put(BundleContext.class.getName(), this.bundleContext);
        eventadminOptions.put(MODULE, EVENTADMIN_AUDIT_MODULE);
        eventadminOptions.put("org.apache.karaf.jaas.bundle", Long.toString(this.bundleContext.getBundle().getBundleId()));
        eventadminOptions.put("enabled", this.properties.get("audit.eventadmin.enabled"));
        eventadminOptions.put("topic", this.properties.get("audit.eventadmin.topic"));
        return new AppConfigurationEntry[]{new AppConfigurationEntry(ProxyLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, propertiesOptions), new AppConfigurationEntry(ProxyLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, publicKeyOptions), new AppConfigurationEntry(ProxyLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, fileOptions), new AppConfigurationEntry(ProxyLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, logOptions), new AppConfigurationEntry(ProxyLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, eventadminOptions)};
    }
}

