/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.specs.locator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiLocator {
    public static final long DEFAULT_TIMEOUT = 0L;
    public static final String TIMEOUT = "org.apache.servicemix.specs.timeout";
    private static Map<String, List<Callable<Class>>> factories;
    private static ReadWriteLock lock;

    private OsgiLocator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(String id, Callable<Class> factory) {
        lock.writeLock().lock();
        try {
            List<Callable<Class>> l;
            if (factories != null && (l = factories.get(id)) != null) {
                l.remove(factory);
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String id, Callable<Class> factory) {
        lock.writeLock().lock();
        try {
            List<Callable<Class>> l;
            if (factories == null) {
                factories = new HashMap<String, List<Callable<Class>>>();
            }
            if ((l = factories.get(id)) == null) {
                l = new ArrayList<Callable<Class>>();
                factories.put(id, l);
            }
            l.add(0, factory);
            ReadWriteLock readWriteLock = lock;
            synchronized (readWriteLock) {
                lock.notifyAll();
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static <T> Class<? extends T> locate(Class<T> factoryId) {
        return OsgiLocator.locate(factoryId, factoryId.getName());
    }

    private static long getTimeout() {
        long timeout = 0L;
        try {
            String prop = System.getProperty(TIMEOUT);
            if (prop != null) {
                timeout = Long.parseLong(prop);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Class<? extends T> locate(Class<T> factoryClass, String factoryId) {
        long t0;
        long timeout = OsgiLocator.getTimeout();
        if (timeout <= 0L) {
            return OsgiLocator.doLocate(factoryClass, factoryId);
        }
        long t1 = t0 = System.currentTimeMillis();
        while (t1 - t0 < timeout) {
            Class<T> impl = OsgiLocator.doLocate(factoryClass, factoryId);
            if (impl != null) {
                return impl;
            }
            ReadWriteLock readWriteLock = lock;
            synchronized (readWriteLock) {
                try {
                    lock.wait(timeout - (t1 - t0));
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
            t1 = System.currentTimeMillis();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> Class<? extends T> doLocate(Class<T> factoryClass, String factoryId) {
        lock.readLock().lock();
        try {
            List<Callable<Class>> l;
            if (factories != null && (l = factories.get(factoryId)) != null && !l.isEmpty()) {
                String factoryClassName = System.getProperty(factoryId);
                try {
                    for (Callable<Class> i : l) {
                        Class c = null;
                        try {
                            c = i.call();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (c == null || factoryClass != c.getClassLoader().loadClass(factoryClass.getName()) || factoryClassName != null && !c.getName().equals(factoryClassName)) continue;
                        Class clazz = c;
                        return clazz;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Class<? extends T> clazz = null;
            return clazz;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static <T> List<Class<? extends T>> locateAll(Class<T> factoryId) {
        return OsgiLocator.locateAll(factoryId, factoryId.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<Class<? extends T>> locateAll(Class<T> factoryClass, String factoryId) {
        lock.readLock().lock();
        try {
            List<Callable<Class>> l;
            ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
            if (factories != null && (l = factories.get(factoryId)) != null) {
                for (Callable<Class> i : l) {
                    try {
                        Class c = i.call();
                        if (c == null || !factoryClass.isAssignableFrom(c)) continue;
                        classes.add(c);
                    }
                    catch (Exception exception) {}
                }
            }
            ArrayList<Class<T>> arrayList = classes;
            return arrayList;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    static {
        lock = new ReentrantReadWriteLock();
    }
}

