/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.maven.repository.internal;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import shaded.org.apache.maven.artifact.repository.metadata.Metadata;
import shaded.org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import shaded.org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import shaded.org.codehaus.plexus.util.IOUtil;
import shaded.org.codehaus.plexus.util.ReaderFactory;
import shaded.org.codehaus.plexus.util.WriterFactory;
import shaded.org.codehaus.plexus.util.xml.XmlStreamReader;
import shaded.org.codehaus.plexus.util.xml.XmlStreamWriter;
import shaded.org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import shaded.org.eclipse.aether.RepositoryException;
import shaded.org.eclipse.aether.metadata.AbstractMetadata;
import shaded.org.eclipse.aether.metadata.MergeableMetadata;

abstract class MavenMetadata
extends AbstractMetadata
implements MergeableMetadata {
    static final String MAVEN_METADATA_XML = "maven-metadata.xml";
    private final File file;
    protected Metadata metadata;
    private boolean merged;

    protected MavenMetadata(Metadata metadata, File file) {
        this.metadata = metadata;
        this.file = file;
    }

    @Override
    public String getType() {
        return MAVEN_METADATA_XML;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void merge(File existing, File result) throws RepositoryException {
        Metadata recessive = MavenMetadata.read(existing);
        this.merge(recessive);
        this.write(result, this.metadata);
        this.merged = true;
    }

    @Override
    public boolean isMerged() {
        return this.merged;
    }

    protected abstract void merge(Metadata var1);

    static Metadata read(File metadataFile) throws RepositoryException {
        if (metadataFile.length() <= 0L) {
            return new Metadata();
        }
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader(metadataFile);
            Metadata metadata = new MetadataXpp3Reader().read(reader, false);
            return metadata;
        }
        catch (IOException e) {
            throw new RepositoryException("Could not read metadata " + metadataFile + ": " + e.getMessage(), e);
        }
        catch (XmlPullParserException e) {
            throw new RepositoryException("Could not parse metadata " + metadataFile + ": " + e.getMessage(), e);
        }
        finally {
            IOUtil.close(reader);
        }
    }

    private void write(File metadataFile, Metadata metadata) throws RepositoryException {
        XmlStreamWriter writer = null;
        try {
            metadataFile.getParentFile().mkdirs();
            writer = WriterFactory.newXmlWriter(metadataFile);
            new MetadataXpp3Writer().write(writer, metadata);
        }
        catch (IOException e) {
            try {
                throw new RepositoryException("Could not write metadata " + metadataFile + ": " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close(writer);
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    @Override
    public shaded.org.eclipse.aether.metadata.Metadata setProperties(Map<String, String> properties) {
        return this;
    }
}

