/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.gss;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.sshd.server.auth.gss.UserAuthGSS;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class CredentialHelper {
    public static GSSCredential creds(GSSManager mgr, String spn, String keytab) throws LoginException, GSSException {
        LoginContext lc = new LoginContext("x", null, null, new FixedLoginConfiguration(spn, keytab));
        lc.login();
        try {
            return Subject.doAs(lc.getSubject(), new G(mgr));
        }
        catch (PrivilegedActionException e) {
            throw (GSSException)e.getCause();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class G
    implements PrivilegedExceptionAction<GSSCredential> {
        private GSSManager mgr;

        private G(GSSManager mgr) {
            this.mgr = mgr;
        }

        @Override
        public GSSCredential run() throws GSSException {
            return this.mgr.createCredential(null, Integer.MAX_VALUE, UserAuthGSS.KRB5_MECH, 2);
        }
    }

    private static class FixedLoginConfiguration
    extends Configuration {
        private AppConfigurationEntry entry;

        private FixedLoginConfiguration(String spn, String keytab) {
            HashMap<String, String> parms = new HashMap<String, String>();
            parms.put("isInitiator", "false");
            parms.put("principal", spn);
            parms.put("useKeyTab", "true");
            parms.put("storeKey", "true");
            if (keytab != null) {
                parms.put("keyTab", keytab);
            }
            this.entry = new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, parms);
        }

        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return new AppConfigurationEntry[]{this.entry};
        }

        public void refresh() {
        }
    }
}

