/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.reflect.Field;

public class Exception
extends Throwable {
    private static final long serialVersionUID = -3387516993124229948L;
    private transient Class[] classContext = SecurityManagerEx.getInstance().getThrowableContext(this);

    public Exception() {
    }

    public Exception(String detailMessage) {
        super(detailMessage);
    }

    public Exception(String detailMessage, Throwable throwable) {
        super(detailMessage, throwable);
    }

    public Exception(Throwable throwable) {
        super(throwable);
    }

    protected Exception(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        try {
            Field field = null;
            if (writableStackTrace) {
                this.fillInStackTrace();
            } else {
                field = Throwable.class.getDeclaredField("stackTrace");
                field.setAccessible(true);
                field.set(this, null);
            }
            field = Throwable.class.getDeclaredField("detailMessage");
            field.setAccessible(true);
            field.set(this, message);
            field = Throwable.class.getDeclaredField("cause");
            field.setAccessible(true);
            field.set(this, cause);
            if (!enableSuppression) {
                field = Throwable.class.getDeclaredField("suppressedExceptions");
                field.setAccessible(true);
                field.set(this, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Class[] getClassContext() {
        return this.classContext;
    }

    private static class SecurityManagerEx
    extends SecurityManager {
        private static SecurityManagerEx sm;

        private SecurityManagerEx() {
        }

        public static SecurityManagerEx getInstance() {
            if (sm == null) {
                sm = new SecurityManagerEx();
            }
            return sm;
        }

        public Class[] getThrowableContext(Throwable t) {
            try {
                Class<?>[] context = this.getClassContext();
                int nb = 0;
                while (context[context.length - 1 - nb] != t.getClass()) {
                    ++nb;
                }
                Class[] nc = new Class[nb];
                System.arraycopy(context, context.length - nb, nc, 0, nb);
                return nc;
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

