/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.mbeans.dev.internal;

import java.io.File;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.karaf.management.mbeans.dev.DevMBean;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DevMBeanImpl
extends StandardMBean
implements DevMBean {
    private BundleContext bundleContext;

    public DevMBeanImpl() throws NotCompliantMBeanException {
        super(DevMBean.class);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public String framework() throws Exception {
        if (this.bundleContext.getBundle(0L).getSymbolicName().contains("felix")) {
            return "Felix";
        }
        return "Equinox";
    }

    @Override
    public void frameworkOptions(boolean debug, String framework) throws Exception {
        org.apache.felix.utils.properties.Properties properties = new org.apache.felix.utils.properties.Properties(new File(System.getProperty("karaf.etc"), "config.properties"));
        if (framework != null) {
            if (!framework.equalsIgnoreCase("felix") && !framework.equalsIgnoreCase("equinox")) {
                throw new IllegalArgumentException("Unsupported framework " + framework);
            }
            properties.put("karaf.framework", framework.toLowerCase());
        }
        if (debug) {
            properties.put("felix.log.level", "4");
            properties.put("osgi.debug", "etc/equinox-debug.properties");
        } else {
            properties.remove("felix.log.level");
            properties.remove("osgi.debug");
        }
        properties.save();
    }

    @Override
    public void restart(boolean clean) throws Exception {
        System.setProperty("karaf.restart", "true");
        System.setProperty("karaf.restart.clean", Boolean.toString(clean));
        this.bundleContext.getBundle(0L).stop();
    }

    @Override
    public Map getProperties(boolean unset, boolean dumpToFile) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        Properties props = (Properties)System.getProperties().clone();
        String def = null;
        if (unset) {
            def = "unset";
        }
        this.setProperty(props, "org.osgi.framework.startlevel.beginning", def);
        this.setProperty(props, "org.osgi.framework.bootdelegation", def);
        this.setProperty(props, "org.osgi.framework.bundle.parent", def);
        this.setProperty(props, "app", def);
        this.setProperty(props, "boot", def);
        this.setProperty(props, "ext", def);
        this.setProperty(props, "framework", def);
        this.setProperty(props, "org.osgi.framework.command.execpermission", def);
        this.setProperty(props, "org.osgi.framework.executionenvironment", def);
        this.setProperty(props, "org.osgi.framework.language", def);
        this.setProperty(props, "org.osgi.framework.library.extensions", def);
        this.setProperty(props, "org.osgi.framework.os.name", def);
        this.setProperty(props, "org.osgi.framework.os.version", def);
        this.setProperty(props, "org.osgi.framework.processor", def);
        this.setProperty(props, "org.osgi.framework.security", def);
        this.setProperty(props, "osgi", def);
        this.setProperty(props, "org.osgi.framework.storage", def);
        this.setProperty(props, "onFirstInit", def);
        this.setProperty(props, "org.osgi.framework.system.packages", def);
        this.setProperty(props, "org.osgi.framework.system.packages.extra", def);
        this.setProperty(props, "org.osgi.framework.vendor", def);
        this.setProperty(props, "org.osgi.framework.version", def);
        this.setProperty(props, "org.osgi.framework.windowsystem", def);
        this.setProperty(props, "org.osgi.supports.bootclasspath.extension", def);
        this.setProperty(props, "org.osgi.supports.framework.extension", def);
        this.setProperty(props, "org.osgi.supports.framework.fragment", def);
        this.setProperty(props, "org.osgi.supports.framework.requirebundle", def);
        if (dumpToFile) {
            PrintStream ps = new PrintStream(new File(this.bundleContext.getProperty("karaf.data"), "dump-properties-" + System.currentTimeMillis() + ".properties"));
            ps.println("#Dump of the System and OSGi properties");
            ps.println("#Dump execute at " + new SimpleDateFormat().format(new Date()));
            this.printOrderedProperties(props, ps);
            ps.flush();
            ps.close();
        } else {
            this.printOrderedProperties(props, result);
        }
        return result;
    }

    private void printOrderedProperties(Properties props, PrintStream out) {
        Set<Object> keys = props.keySet();
        Vector<String> order = new Vector<String>(keys.size());
        for (Object str : keys) {
            order.add((String)str);
        }
        Collections.sort(order);
        for (String key : order) {
            out.println(key + "=" + props.getProperty(key));
        }
    }

    private void printOrderedProperties(Properties props, Map<String, String> result) {
        Set<Object> keys = props.keySet();
        Vector<String> order = new Vector<String>(keys.size());
        for (Object str : keys) {
            order.add((String)str);
        }
        Collections.sort(order);
        for (String key : order) {
            result.put(key, props.getProperty(key));
        }
    }

    private void setProperty(Properties props, String key, String def) {
        String val = this.bundleContext.getProperty(key);
        if (val == null && def != null) {
            props.setProperty(key, def);
        } else if (val != null) {
            props.setProperty(key, val);
        }
    }

    @Override
    public String getProperty(String key) {
        return System.getProperty(key);
    }

    @Override
    public void setProperty(String key, String value, boolean persistent) throws Exception {
        if (persistent) {
            String etc = System.getProperty("karaf.etc");
            org.apache.felix.utils.properties.Properties props = new org.apache.felix.utils.properties.Properties(new File(etc, "system.properties"));
            props.put(key, value);
            props.save();
        }
        System.setProperty(key, value);
    }
}

