/*
 * Decompiled with CFR 0.152.
 */
package org.jledit.command.undo;

import org.jledit.ConsoleEditor;
import org.jledit.command.Command;
import org.jledit.command.undo.UndoContext;
import org.jledit.command.undo.UndoContextAware;
import org.jledit.command.undo.UndoableCommand;

public class UndoCommand
implements UndoContextAware,
Command {
    private UndoContext context;
    private final ConsoleEditor editor;

    public UndoCommand(ConsoleEditor editor) {
        this.context = new UndoContext();
        this.editor = editor;
    }

    public UndoCommand(ConsoleEditor editor, UndoContext context) {
        this.editor = editor;
        this.context = context;
    }

    @Override
    public void setUndoContext(UndoContext context) {
        this.context = context;
    }

    @Override
    public void execute() {
        if (this.context != null) {
            UndoableCommand undoableCommand = this.context.undoPop();
            if (undoableCommand != null) {
                undoableCommand.undo();
                this.context.redoPush(undoableCommand);
            }
            this.editor.setDirty(this.context.isDirty());
        }
    }
}

