/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import jline.Terminal;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.jaas.modules.JaasHelper;
import org.apache.karaf.shell.console.jline.Console;
import org.apache.karaf.shell.ssh.KarafJaasAuthenticator;
import org.apache.karaf.shell.ssh.SshTerminal;
import org.apache.sshd.common.Factory;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.osgi.framework.BundleContext;
import org.osgi.service.blueprint.container.ReifiedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellFactoryImpl
implements Factory<Command> {
    private static final Class[] SECURITY_BUGFIX = new Class[]{JaasHelper.class, JaasHelper.OsgiSubjectDomainCombiner.class, JaasHelper.DelegatingProtectionDomain.class};
    private static final Logger LOGGER = LoggerFactory.getLogger(ShellFactoryImpl.class);
    private CommandProcessor commandProcessor;
    private ThreadIO threadIO;
    private BundleContext bundleContext;

    public void setCommandProcessor(CommandProcessor commandProcessor) {
        this.commandProcessor = commandProcessor;
    }

    public void setThreadIO(ThreadIO threadIO) {
        this.threadIO = threadIO;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Command create() {
        return new ShellImpl();
    }

    private static void flush(OutputStream ... streams) {
        for (OutputStream s : streams) {
            try {
                s.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                c.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public static String getEncoding() {
        String envEncoding = ShellFactoryImpl.extractEncodingFromCtype(System.getenv("LC_CTYPE"));
        if (envEncoding != null) {
            return envEncoding;
        }
        return System.getProperty("input.encoding", Charset.defaultCharset().name());
    }

    static String extractEncodingFromCtype(String ctype) {
        if (ctype != null && ctype.indexOf(46) > 0) {
            String encodingAndModifier = ctype.substring(ctype.indexOf(46) + 1);
            if (encodingAndModifier.indexOf(64) > 0) {
                return encodingAndModifier.substring(0, encodingAndModifier.indexOf(64));
            }
            return encodingAndModifier;
        }
        return null;
    }

    public static Converter getConverter() {
        return new Converter();
    }

    public class LfToCrLfFilterOutputStream
    extends FilterOutputStream {
        private boolean lastWasCr;

        public LfToCrLfFilterOutputStream(OutputStream out) {
            super(out);
        }

        public void write(int b) throws IOException {
            if (!this.lastWasCr && b == 10) {
                this.out.write(13);
                this.out.write(10);
            } else {
                this.out.write(b);
            }
            this.lastWasCr = b == 13;
        }
    }

    public static class Converter
    implements org.osgi.service.blueprint.container.Converter {
        public boolean canConvert(Object sourceObject, ReifiedType targetType) {
            return ShellFactoryImpl.class.isAssignableFrom(sourceObject.getClass()) && Factory.class.equals((Object)targetType.getRawClass()) && Command.class.equals((Object)targetType.getActualTypeArgument(0).getRawClass());
        }

        public Object convert(Object sourceObject, ReifiedType targetType) throws Exception {
            return sourceObject;
        }
    }

    public class ShellImpl
    implements Command,
    SessionAware {
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private ExitCallback callback;
        private ServerSession session;
        private boolean closed;

        public void setInputStream(InputStream in) {
            this.in = in;
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        public void setErrorStream(OutputStream err) {
            this.err = err;
        }

        public void setExitCallback(ExitCallback callback) {
            this.callback = callback;
        }

        public void setSession(ServerSession session) {
            this.session = session;
        }

        public void start(final Environment env) throws IOException {
            new Thread(){

                public void run() {
                    Subject subject;
                    Subject subject2 = subject = ShellImpl.this.session != null ? (Subject)ShellImpl.this.session.getAttribute(KarafJaasAuthenticator.SUBJECT_ATTRIBUTE_KEY) : null;
                    if (subject != null) {
                        JaasHelper.doAs((Subject)subject, (PrivilegedAction)new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                this.runConsole();
                                return null;
                            }
                        });
                    } else {
                        this.runConsole();
                    }
                }

                protected void runConsole() {
                    try {
                        SshTerminal terminal = new SshTerminal(env);
                        String encoding = ShellFactoryImpl.getEncoding();
                        Console console = new Console(ShellFactoryImpl.this.commandProcessor, ShellFactoryImpl.this.threadIO, ShellImpl.this.in, new PrintStream(new LfToCrLfFilterOutputStream(ShellImpl.this.out), true), new PrintStream(new LfToCrLfFilterOutputStream(ShellImpl.this.err), true), (Terminal)terminal, encoding, new Runnable(){

                            public void run() {
                                ShellImpl.this.destroy();
                            }
                        }, ShellFactoryImpl.this.bundleContext);
                        CommandSession session = console.getSession();
                        session.put("APPLICATION", (Object)System.getProperty("karaf.name", "root"));
                        for (Map.Entry e : env.getEnv().entrySet()) {
                            session.put((String)e.getKey(), e.getValue());
                        }
                        session.put("#LINES", (Object)new Function((Terminal)terminal){
                            final /* synthetic */ Terminal val$terminal;
                            {
                                this.val$terminal = terminal;
                            }

                            public Object execute(CommandSession session, List<Object> arguments) throws Exception {
                                return Integer.toString(this.val$terminal.getHeight());
                            }
                        });
                        session.put("#COLUMNS", (Object)new Function((Terminal)terminal){
                            final /* synthetic */ Terminal val$terminal;
                            {
                                this.val$terminal = terminal;
                            }

                            public Object execute(CommandSession session, List<Object> arguments) throws Exception {
                                return Integer.toString(this.val$terminal.getWidth());
                            }
                        });
                        session.put(".jline.terminal", (Object)terminal);
                        console.run();
                    }
                    catch (Exception e) {
                        LOGGER.warn("Unable to start shell", (Throwable)e);
                        try {
                            ShellImpl.this.out.write(("unable to start shell because " + e.getMessage() + "\n").getBytes());
                            ShellImpl.this.out.flush();
                        }
                        catch (IOException e1) {
                            LOGGER.warn("Unable to send back error message", (Throwable)e1);
                        }
                        ShellImpl.this.session.close(true);
                    }
                }
            }.start();
        }

        public void destroy() {
            if (!this.closed) {
                this.closed = true;
                ShellFactoryImpl.flush(new OutputStream[]{this.out, this.err});
                ShellFactoryImpl.close(new Closeable[]{this.in, this.out, this.err});
                this.callback.onExit(0);
            }
        }
    }
}

