/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.dev;

import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.dev.watch.BundleWatcher;
import org.osgi.framework.Bundle;

@Command(scope="dev", name="watch", description="Watches and updates bundles.", detailedDescription="classpath:watch.txt")
public class Watch
extends OsgiCommandSupport {
    @Argument(index=0, name="urls", description="The bundle IDs or URLs", required=false, multiValued=true)
    List<String> urls;
    @Option(name="-i", aliases={}, description="Watch interval", required=false, multiValued=false)
    private long interval;
    @Option(name="--start", description="Starts watching the selected bundles", required=false, multiValued=false)
    protected boolean start;
    @Option(name="--stop", description="Stops watching all bundles", required=false, multiValued=false)
    protected boolean stop;
    @Option(name="--remove", description="Removes bundles from the watch list", required=false, multiValued=false)
    protected boolean remove;
    @Option(name="--list", description="Displays the watch list", required=false, multiValued=false)
    protected boolean list;
    private BundleWatcher watcher;

    protected Object doExecute() throws Exception {
        if (this.start && this.stop) {
            System.err.println("Please use only one of --start and --stop options!");
            return null;
        }
        if (this.interval > 0L) {
            System.out.println("Setting watch interval to " + this.interval + " ms");
            this.watcher.setInterval(this.interval);
        }
        if (this.stop) {
            System.out.println("Stopping watch");
            this.watcher.stop();
        }
        if (this.urls != null) {
            if (this.remove) {
                for (String url : this.urls) {
                    this.watcher.remove(url);
                }
            } else {
                for (String url : this.urls) {
                    this.watcher.add(url);
                }
            }
        }
        if (this.start) {
            System.out.println("Starting watch");
            this.watcher.start();
        }
        if (this.list) {
            String format = "%-40s %6s %-80s";
            System.out.println(String.format(format, "URL", "ID", "Bundle Name"));
            for (String url : this.watcher.getWatchURLs()) {
                List<Bundle> bundleList = this.watcher.getBundlesByURL(url);
                if (bundleList != null && bundleList.size() > 0) {
                    for (Bundle bundle : bundleList) {
                        System.out.println(String.format(format, url, bundle.getBundleId(), bundle.getHeaders().get("Bundle-Name")));
                    }
                    continue;
                }
                System.out.println(String.format(format, url, "", ""));
            }
        } else {
            List<String> urls = this.watcher.getWatchURLs();
            if (urls != null && urls.size() > 0) {
                System.out.println("Watched URLs/IDs: ");
                for (String url : this.watcher.getWatchURLs()) {
                    System.out.println(url);
                }
            } else {
                System.out.println("No watched URLs/IDs");
            }
        }
        return null;
    }

    public BundleWatcher getWatcher() {
        return this.watcher;
    }

    public void setWatcher(BundleWatcher watcher) {
        this.watcher = watcher;
    }
}

